/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.maxsat;

import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.sat4j.AbstractLauncher;
import org.sat4j.ILauncherMode;
import org.sat4j.maxsat.MinCostDecorator;
import org.sat4j.maxsat.SolverFactory;
import org.sat4j.maxsat.WeightedMaxSatDecorator;
import org.sat4j.maxsat.reader.WDimacsReader;
import org.sat4j.opt.MinOneDecorator;
import org.sat4j.pb.ConstraintRelaxingPseudoOptDecorator;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.OptToPBSATAdapter;
import org.sat4j.pb.PseudoOptDecorator;
import org.sat4j.pb.core.PBSolver;
import org.sat4j.pb.tools.ManyCorePB;
import org.sat4j.pb.tools.SearchOptimizerListener;
import org.sat4j.reader.LecteurDimacs;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.SearchListener;
import org.sat4j.tools.SolutionFoundListener;

public class GenericOptLauncher
extends AbstractLauncher {
    private static final long serialVersionUID = 1L;
    private WeightedMaxSatDecorator wmsd;

    public GenericOptLauncher() {
        this.setLauncherMode(ILauncherMode.OPTIMIZATION);
    }

    private Options createCLIOptions() {
        Options options = new Options();
        options.addOption("s", "solver", true, "specifies the name of a PB solver");
        options.addOption("t", "timeout", true, "specifies the timeout (in seconds)");
        options.addOption("p", "parallel", false, "uses CP and RES pseudo-boolean solvers in parallel");
        options.addOption("T", "timeoutms", true, "specifies the timeout (in milliseconds)");
        options.addOption("K", "kind", true, "kind of problem: minone, maxsat, etc.");
        options.addOption("i", "incomplete", false, "incomplete mode for maxsat");
        options.addOption("I", "inner mode", false, "optimize using inner mode");
        options.addOption("c", "clean databases", false, "clean up the database at root level");
        options.addOption("k", "keep Hot", false, "Keep heuristics accross calls to the SAT solver");
        options.addOption("e", "equivalence", false, "Use an equivalence instead of an implication for the selector variables");
        options.addOption("pi", "prime-implicant", false, "Use prime implicants instead of models for evaluating the objective function");
        options.addOption("n", "no solution line", false, "Do not display a solution line (useful if the solution is large)");
        options.addOption("l", "lower bounding", false, "search solution by lower bounding instead of by upper bounding");
        options.addOption("hs", "MaxHS Like", false, "search solution using a MaxHS like approach");
        options.addOption("m", "mystery", false, "mystery option");
        options.addOption("B", "External&Internal", false, "External&Internal optimization");
        return options;
    }

    public void displayLicense() {
        super.displayLicense();
        this.log("This software uses some libraries from the Jakarta Commons project. See jakarta.apache.org for details.");
    }

    public void usage() {
        this.out.println("java -jar sat4j-maxsat.jar instance-name");
    }

    protected Reader createReader(ISolver aSolver, String problemname) {
        Object reader = problemname.contains(".wcnf") ? new WDimacsReader(this.wmsd) : new LecteurDimacs(aSolver);
        reader.setVerbosity(true);
        return reader;
    }

    protected String getInstanceName(String[] args) {
        return args[args.length - 1];
    }

    protected ISolver configureSolver(String[] args) {
        Object asolver = null;
        Options options = this.createCLIOptions();
        if (args.length == 0) {
            HelpFormatter helpf = new HelpFormatter();
            helpf.printHelp("java -jar sat4j-maxsat.jar", options, true);
            System.exit(0);
        } else {
            try {
                String timeout;
                String aPBSolverName;
                CommandLine cmd = new PosixParser().parse(options, args);
                int problemindex = args.length - 1;
                this.setDisplaySolutionLine(!cmd.hasOption("n"));
                boolean equivalence = cmd.hasOption("e");
                String kind = cmd.getOptionValue("K");
                if (kind == null) {
                    kind = "maxsat";
                }
                if ((aPBSolverName = cmd.getOptionValue("s")) == null) {
                    aPBSolverName = "Default";
                }
                if ("minone".equalsIgnoreCase(kind)) {
                    asolver = new MinOneDecorator(org.sat4j.minisat.SolverFactory.newDefault());
                } else if ("mincost".equalsIgnoreCase(kind) || args[problemindex].endsWith(".p2cnf")) {
                    asolver = new MinCostDecorator(SolverFactory.newDefault());
                } else {
                    assert ("maxsat".equalsIgnoreCase(kind));
                    this.wmsd = cmd.hasOption("m") ? new WeightedMaxSatDecorator(org.sat4j.pb.SolverFactory.newSATUNSAT(), equivalence) : (cmd.hasOption("p") ? new WeightedMaxSatDecorator(org.sat4j.pb.SolverFactory.newBoth(), equivalence) : new WeightedMaxSatDecorator((IPBSolver)org.sat4j.pb.SolverFactory.instance().createSolverByName(aPBSolverName), equivalence));
                    if (cmd.hasOption("l")) {
                        asolver = new ConstraintRelaxingPseudoOptDecorator((IPBSolver)this.wmsd);
                    } else if (cmd.hasOption("hs")) {
                        asolver = SolverFactory.newMaxHSLike();
                        this.setLauncherMode(ILauncherMode.DECISION);
                    } else if (cmd.hasOption("I")) {
                        this.wmsd.setSearchListener((SearchListener)new SearchOptimizerListener((SolutionFoundListener)ILauncherMode.DECISION));
                        this.setLauncherMode(ILauncherMode.DECISION);
                        asolver = this.wmsd;
                    } else if (cmd.hasOption("B")) {
                        PBSolver internal = org.sat4j.pb.SolverFactory.newDefault();
                        internal.setSearchListener((SearchListener)new SearchOptimizerListener((SolutionFoundListener)ILauncherMode.DECISION));
                        PBSolver external = org.sat4j.pb.SolverFactory.newDefault();
                        external = new OptToPBSATAdapter((IOptimizationProblem)new PseudoOptDecorator((IPBSolver)external), (SolutionFoundListener)ILauncherMode.DECISION);
                        ManyCorePB mc = new ManyCorePB(new IPBSolver[]{external, internal});
                        this.wmsd = new WeightedMaxSatDecorator((IPBSolver)mc, equivalence);
                        this.setLauncherMode(ILauncherMode.DECISION);
                        asolver = this.wmsd;
                    } else {
                        asolver = new PseudoOptDecorator((IPBSolver)this.wmsd, false, cmd.hasOption("pi"));
                    }
                }
                if (cmd.hasOption("i")) {
                    this.setIncomplete(true);
                }
                if (cmd.hasOption("c")) {
                    asolver.setDBSimplificationAllowed(true);
                }
                if (cmd.hasOption("k")) {
                    asolver.setKeepSolverHot(true);
                }
                if ((timeout = cmd.getOptionValue("t")) == null) {
                    timeout = cmd.getOptionValue("T");
                    if (timeout != null) {
                        asolver.setTimeoutMs(Long.parseLong(timeout));
                    }
                } else {
                    asolver.setTimeout(Integer.parseInt(timeout));
                }
                this.getLogWriter().println(asolver.toString("c "));
            }
            catch (ParseException e1) {
                HelpFormatter helpf = new HelpFormatter();
                helpf.printHelp("java -jar sat4jopt.jar", options, true);
            }
        }
        return asolver;
    }

    public static void main(String[] args) {
        GenericOptLauncher lanceur = new GenericOptLauncher();
        lanceur.addHook();
        lanceur.run(args);
    }

    protected IProblem readProblem(String problemname) throws ParseFormatException, IOException, ContradictionException {
        super.readProblem(problemname);
        return this.solver;
    }
}

