/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.maxsat;

import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.PBSolverDecorator;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;

public class MinCostDecorator
extends PBSolverDecorator
implements IOptimizationProblem {
    private static final long serialVersionUID = 1L;
    private int[] costs;
    private int[] prevmodel;
    private final IVecInt vars = new VecInt();
    private final IVec<BigInteger> coeffs = new Vec();
    private int objectivevalue;
    private IConstr prevConstr;
    private boolean isSolutionOptimal;

    public MinCostDecorator(IPBSolver solver) {
        super(solver);
    }

    public int newVar() {
        throw new UnsupportedOperationException();
    }

    public int newVar(int howmany) {
        this.costs = new int[howmany + 1];
        this.vars.clear();
        this.coeffs.clear();
        int i = 1;
        while (i <= howmany) {
            this.vars.push(i);
            this.coeffs.push((Object)BigInteger.ZERO);
            ++i;
        }
        return super.newVar(howmany);
    }

    public int costOf(int var) {
        return this.costs[var];
    }

    public void setCost(int var, int cost) {
        this.costs[var] = cost;
        this.coeffs.set(var - 1, (Object)BigInteger.valueOf(cost));
    }

    public boolean admitABetterSolution() throws TimeoutException {
        return this.admitABetterSolution(VecInt.EMPTY);
    }

    public boolean admitABetterSolution(IVecInt assumps) throws TimeoutException {
        this.isSolutionOptimal = false;
        boolean result = super.isSatisfiable(assumps, true);
        if (result) {
            this.prevmodel = super.model();
            this.calculateObjective();
        } else {
            this.isSolutionOptimal = true;
        }
        return result;
    }

    public boolean hasNoObjectiveFunction() {
        return false;
    }

    public boolean nonOptimalMeansSatisfiable() {
        return true;
    }

    public Number calculateObjective() {
        this.objectivevalue = this.calculateDegree(this.prevmodel);
        return this.objectivevalue;
    }

    private int calculateDegree(int[] prevmodel2) {
        int tmpcost = 0;
        int i = 1;
        while (i < this.costs.length) {
            if (prevmodel2[i - 1] > 0) {
                tmpcost += this.costs[i];
            }
            ++i;
        }
        return tmpcost;
    }

    public void discardCurrentSolution() throws ContradictionException {
        if (this.prevConstr != null) {
            super.removeSubsumedConstr(this.prevConstr);
        }
        try {
            this.prevConstr = super.addPseudoBoolean(this.vars, this.coeffs, false, BigInteger.valueOf(this.objectivevalue - 1));
        }
        catch (ContradictionException e) {
            this.isSolutionOptimal = true;
            throw e;
        }
    }

    public void reset() {
        this.prevConstr = null;
        super.reset();
    }

    public int[] model() {
        return this.prevmodel;
    }

    public Number getObjectiveValue() {
        return this.objectivevalue;
    }

    public void discard() throws ContradictionException {
        this.discardCurrentSolution();
    }

    public void forceObjectiveValueTo(Number forcedValue) throws ContradictionException {
        super.addPseudoBoolean(this.vars, this.coeffs, false, (BigInteger)forcedValue);
    }

    public boolean isOptimal() {
        return this.isSolutionOptimal;
    }

    public void setTimeoutForFindingBetterSolution(int seconds) {
        throw new UnsupportedOperationException("No implemented yet");
    }
}

