/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.wrapper.log4j;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.xml.DOMConfigurator;
import org.objectweb.util.monolog.Monolog;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.LogInfo;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.TopicalLogger;
import org.objectweb.util.monolog.wrapper.common.AbstractFactory;
import org.objectweb.util.monolog.wrapper.log4j.LevelImpl;
import org.objectweb.util.monolog.wrapper.log4j.MonologCategory;
import org.objectweb.util.monolog.wrapper.log4j.MonologCategoryFactory;

public class MonologLoggerFactory
extends AbstractFactory {
    public static final String LOG4J_CF_PROP = "log4j.categoryFactory";
    public static final String LOG4J_CF_VALUE = "org.objectweb.util.monolog.wrapper.log4j.MonologCategoryFactory";
    protected static Logger rootLogger = null;
    private static LoggerFactory factory = new MonologCategoryFactory();

    public MonologLoggerFactory() {
        if (!classLoaderIsoltion) {
            rootLogger = new MonologCategory(org.apache.log4j.Logger.getRootLogger());
        }
    }

    public String getWrapperName() {
        return "log4j";
    }

    protected String[][] getDefaultHandlerType2className() {
        return new String[][]{{handlerTypes[0], "org.objectweb.util.monolog.wrapper.log4j.ConsoleHandler"}, {handlerTypes[1], "org.objectweb.util.monolog.wrapper.log4j.FileHandler"}, {handlerTypes[2], "org.objectweb.util.monolog.wrapper.log4j.RollingFileHandler"}, {handlerTypes[3], "org.objectweb.util.monolog.wrapper.log4j.NTEventLogHandler"}, {handlerTypes[4], "org.objectweb.util.monolog.wrapper.log4j.JMXHandler"}, {handlerTypes[5], "org.objectweb.util.monolog.wrapper.log4j.SocketHubHandler"}, {handlerTypes[6], "org.objectweb.util.monolog.wrapper.log4j.GenericHandler"}};
    }

    public void configure(Properties prop) throws Exception {
        MonologLoggerFactory.debug((String)("MonologLoggerFactory.configure(prop=" + prop + ")"));
        if (prop == null) {
            if (!org.apache.log4j.Logger.getRootLogger().getAllAppenders().hasMoreElements()) {
                BasicConfigurator.configure();
            }
            return;
        }
        String conf = prop.getProperty("log.config.type", prop.getProperty("log4jConfiguration", "default"));
        MonologLoggerFactory.debug((String)("MonologLoggerFactory.configure(): conf=" + conf));
        if ("default".equals(conf)) {
            if (!org.apache.log4j.Logger.getRootLogger().getAllAppenders().hasMoreElements()) {
                BasicConfigurator.configure();
            }
            return;
        }
        String filename = prop.getProperty("log.config.file", prop.getProperty("log4jConfigurationFile", ""));
        MonologLoggerFactory.debug((String)("MonologLoggerFactory.configure(): filename=" + filename));
        if ("xml".equals(conf)) {
            if (prop.getProperty("log.config.file.useclasspath", "false").equalsIgnoreCase("true") || prop.getProperty("findFileInClassPath", "false").equalsIgnoreCase("true")) {
                MonologLoggerFactory.debug((String)"MonologLoggerFactory.configure(): load from classpath");
                URL configFileResource = ((Object)((Object)this)).getClass().getClassLoader().getResource(filename);
                DOMConfigurator.configure((String)configFileResource.getFile());
            } else {
                MonologLoggerFactory.debug((String)"MonologLoggerFactory.configure(): load from file system");
                DOMConfigurator.configure((String)filename);
            }
        } else if ("property".equals(conf)) {
            Properties log4jfileprop = null;
            if (prop.getProperty("log.config.file.useclasspath", "false").equalsIgnoreCase("true") || prop.getProperty("findFileInClassPath", "false").equalsIgnoreCase("true")) {
                MonologLoggerFactory.debug((String)"MonologLoggerFactory.configure(): load from classpath");
                if (!"log4j.properties".equals(filename)) {
                    MonologLoggerFactory.debug((String)"MonologLoggerFactory.configure(): not default config file");
                    log4jfileprop = this.getProperties(filename);
                    log4jfileprop.setProperty(LOG4J_CF_PROP, LOG4J_CF_VALUE);
                    PropertyConfigurator.configure((Properties)log4jfileprop);
                }
            } else {
                MonologLoggerFactory.debug((String)"MonologLoggerFactory.configure(): load from file system");
                log4jfileprop = new Properties();
                log4jfileprop.load(new FileInputStream(filename));
                log4jfileprop.setProperty(LOG4J_CF_PROP, LOG4J_CF_VALUE);
                PropertyConfigurator.configure((Properties)log4jfileprop);
            }
        } else {
            throw new Exception("Unsupported configuration type: " + conf);
        }
        MonologLoggerFactory.debug((String)"MonologLoggerFactory.configure(): End");
    }

    private Properties getProperties(String name) throws IOException {
        InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(name);
        if (is != null) {
            Properties props = new Properties();
            props.load(is);
            return props;
        }
        throw new FileNotFoundException("Not found in classpath: " + name);
    }

    public Logger getLogger(String key) {
        if (key == null || key.length() == 0 || key.equalsIgnoreCase("root")) {
            return rootLogger;
        }
        key = MonologLoggerFactory.monoLoggerName((String)key);
        if (this.resourceBundleName == null) {
            return (Logger)org.apache.log4j.Logger.getLogger((String)key, (LoggerFactory)factory);
        }
        return this.getLogger(key, this.resourceBundleName);
    }

    public synchronized Logger getLogger(String key, String rbn) {
        if (key == null || key.length() == 0 || key.equalsIgnoreCase("root")) {
            return rootLogger;
        }
        key = MonologLoggerFactory.monoLoggerName((String)key);
        org.apache.log4j.Logger res = org.apache.log4j.Logger.getLogger((String)key, (LoggerFactory)factory);
        res.setResourceBundle(ResourceBundle.getBundle(rbn));
        return (Logger)res;
    }

    public Logger[] getLoggers() {
        HashSet al = new HashSet();
        Enumeration e = LogManager.getCurrentLoggers();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (!(o instanceof Logger)) continue;
            al.add(o);
        }
        al.add(rootLogger);
        return (Logger[])al.toArray(new TopicalLogger[0]);
    }

    public void addLogInfo(Character pattern, LogInfo logInfoProvider) {
    }

    public void removeLogInfo(char pattern) {
    }

    public LogInfo getLogInfo(Character pattern) {
        return null;
    }

    static {
        MonologLoggerFactory.debug((String)("Initializing " + MonologLoggerFactory.class.getName()));
        MonologLoggerFactory.debug((String)"set default level values");
        BasicLevel.INHERIT = -1;
        MonologLoggerFactory.debug((String)("\t-INHERIT= " + BasicLevel.INHERIT));
        BasicLevel.DEBUG = Level.DEBUG.toInt();
        MonologLoggerFactory.debug((String)("\t-DEBUG= " + BasicLevel.DEBUG));
        BasicLevel.INFO = Level.INFO.toInt();
        MonologLoggerFactory.debug((String)("\t-INFO= " + BasicLevel.INFO));
        BasicLevel.WARN = Level.WARN.toInt();
        MonologLoggerFactory.debug((String)("\t-WARN= " + BasicLevel.WARN));
        BasicLevel.ERROR = Level.ERROR.toInt();
        MonologLoggerFactory.debug((String)("\t-ERROR= " + BasicLevel.ERROR));
        BasicLevel.FATAL = Level.FATAL.toInt();
        MonologLoggerFactory.debug((String)("\t-FATAL= " + BasicLevel.FATAL));
        BasicLevel.LEVEL_INHERIT = new LevelImpl("INHERIT", BasicLevel.INHERIT);
        BasicLevel.LEVEL_DEBUG = new LevelImpl("DEBUG", BasicLevel.DEBUG);
        BasicLevel.LEVEL_INFO = new LevelImpl("INFO", BasicLevel.INFO);
        BasicLevel.LEVEL_WARN = new LevelImpl("WARN", BasicLevel.WARN);
        BasicLevel.LEVEL_ERROR = new LevelImpl("ERROR", BasicLevel.ERROR);
        BasicLevel.LEVEL_FATAL = new LevelImpl("FATAL", BasicLevel.FATAL);
        if (!org.apache.log4j.Logger.getRootLogger().getAllAppenders().hasMoreElements()) {
            BasicConfigurator.configure();
        }
        if (classLoaderIsoltion) {
            MonologLoggerFactory.debug((String)"class loader isolation activated");
            String rootName = null;
            int i = 0;
            while (rootLogger == null) {
                rootName = "root" + i;
                try {
                    org.apache.log4j.Logger rlog = org.apache.log4j.Logger.getLogger((String)rootName, (LoggerFactory)factory);
                    rlog.setAdditivity(false);
                    rootLogger = (Logger)rlog;
                    Monolog.debug((String)("Instanciate the root logger " + rootName));
                }
                catch (ClassCastException exc) {
                    ++i;
                }
            }
            rootLoggerName = rootName;
            rootLoggerPrefix = rootLoggerName + '.';
        }
    }
}

