/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.wrapper.log4j;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.spi.LoggingEvent;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Handler;
import org.objectweb.util.monolog.api.Level;
import org.objectweb.util.monolog.api.TopicalLogger;
import org.objectweb.util.monolog.wrapper.common.AbstractFactory;
import org.objectweb.util.monolog.wrapper.common.EnumrationImpl;
import org.objectweb.util.monolog.wrapper.log4j.GenericHandler;
import org.objectweb.util.monolog.wrapper.log4j.LevelImpl;

public class MonologCategory
extends Logger
implements TopicalLogger {
    protected boolean enable = true;
    protected static final int DISABLE_OFF = -1;
    protected static final int DISABLE_ON = org.apache.log4j.Level.FATAL.toInt();
    protected OwPriority interPriority = null;
    protected byte depth = (byte)2;
    protected HashMap topicToparents = null;
    protected ArrayList appenders = null;
    protected Logger categ = null;
    private static final String instanceFQN = "org.objectweb.util.monolog.wrapper.log4j.MonologCategory";

    public MonologCategory(String _initialName) {
        super(_initialName);
        this.topicToparents = new HashMap();
    }

    public MonologCategory(Logger c) {
        super(c.getName());
        this.categ = c;
    }

    public static String format(String msg, int removeTopStack) {
        Throwable t = new Throwable().fillInStackTrace();
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        String m = sw.getBuffer().toString();
        int deb = -1;
        int fin = 0;
        deb = -1;
        for (int i = 0; i < removeTopStack + 1; ++i) {
            deb = m.indexOf("\n", deb + 1);
        }
        deb = m.indexOf("at ", deb);
        fin = m.indexOf("\n", deb);
        m = m.substring(deb + 3, fin);
        deb = m.indexOf("(");
        fin = m.indexOf(":");
        m = m.substring(0, deb + 1) + m.substring(fin + 1, m.length());
        deb = m.indexOf("(");
        int c1 = 0;
        int c2 = 0;
        int current = m.indexOf(".");
        while (current != -1 && current < deb) {
            c1 = c2;
            c2 = current;
            current = m.indexOf(".", current + 1);
        }
        m = m.substring(c1 + 1, m.length());
        return m + ": " + msg;
    }

    private org.apache.log4j.Level convertToLog4jLevel(int value) {
        switch (value) {
            case 10000: {
                return org.apache.log4j.Level.DEBUG;
            }
            case 20000: {
                return org.apache.log4j.Level.INFO;
            }
            case 30000: {
                return org.apache.log4j.Level.WARN;
            }
            case 40000: {
                return org.apache.log4j.Level.ERROR;
            }
            case 50000: {
                return org.apache.log4j.Level.FATAL;
            }
        }
        if (this.interPriority == null) {
            this.interPriority = new OwPriority(value);
        } else {
            this.interPriority.level = value;
        }
        return this.interPriority;
    }

    public org.apache.log4j.Level getChainedLevel() {
        if (this.categ != null) {
            return this.categ.getEffectiveLevel();
        }
        if (this.level != null) {
            return this.level;
        }
        org.apache.log4j.Level current = this.parent.getEffectiveLevel();
        Logger[] cats = this.topicToparents.values().toArray(new Logger[0]);
        for (int i = 0; i < cats.length; ++i) {
            org.apache.log4j.Level neo = cats[i].getEffectiveLevel();
            if (!neo.isGreaterOrEqual((Priority)current)) continue;
            current = neo;
        }
        return current;
    }

    public void callAppenders(LoggingEvent event) {
        if (this.categ != null) {
            this.categ.callAppenders(event);
        }
        this.callAppenders(event, false);
    }

    public synchronized boolean callAppenders(LoggingEvent event, boolean called) {
        org.apache.log4j.Level l = event.getLevel();
        if (called || this.level != null && l.isGreaterOrEqual((Priority)this.level)) {
            Enumeration en = this.getAllAppenders();
            while (en.hasMoreElements()) {
                ((Appender)en.nextElement()).doAppend(event);
            }
            if (this.additive) {
                if (this.parent instanceof MonologCategory) {
                    ((MonologCategory)this.parent).callAppenders(event, true);
                } else {
                    this.parent.callAppenders(event);
                }
                for (Logger c : this.topicToparents.values()) {
                    if (c instanceof MonologCategory) {
                        ((MonologCategory)c).callAppenders(event, true);
                        continue;
                    }
                    c.callAppenders(event);
                }
            }
            return true;
        }
        if (this.level == null && this.additive) {
            if (this.parent instanceof MonologCategory) {
                called |= ((MonologCategory)this.parent).callAppenders(event, false);
            } else if (this.parent.isEnabledFor((Priority)l)) {
                called = true;
                this.parent.callAppenders(event);
            }
            for (Logger c : this.topicToparents.values()) {
                if (c instanceof MonologCategory) {
                    called |= ((MonologCategory)c).callAppenders(event, false);
                    continue;
                }
                if (!c.isEnabledFor((Priority)l)) continue;
                called = true;
                c.callAppenders(event);
            }
            if (called) {
                Enumeration en = this.getAllAppenders();
                while (en.hasMoreElements()) {
                    ((Appender)en.nextElement()).doAppend(event);
                }
            }
        }
        return called;
    }

    public boolean isLoggable(int l) {
        if (this.categ != null) {
            return l >= this.categ.getEffectiveLevel().toInt();
        }
        return l >= this.getEffectiveLevel().toInt();
    }

    public boolean isLoggable(Level l) {
        if (this.categ != null) {
            return l.getIntValue() >= this.categ.getEffectiveLevel().toInt();
        }
        return l.getIntValue() >= this.getEffectiveLevel().toInt();
    }

    public boolean isOn() {
        return this.enable;
    }

    public void log(int l, Object o) {
        if (!this.enable || !this.isLoggable(l)) {
            return;
        }
        if (this.categ != null) {
            this.categ.log((Priority)this.convertToLog4jLevel(l), o == null ? o : o.toString(), null);
        } else {
            this.forcedLog(instanceFQN, (Priority)this.convertToLog4jLevel(l), o == null ? o : o.toString(), null);
        }
    }

    public void log(Level l, Object o) {
        if (!this.enable || !this.isLoggable(l.getIntValue())) {
            return;
        }
        if (this.categ != null) {
            this.categ.log((Priority)this.convertToLog4jLevel(l.getIntValue()), o == null ? o : o.toString(), null);
        } else {
            this.forcedLog(instanceFQN, (Priority)this.convertToLog4jLevel(l.getIntValue()), o == null ? o : o.toString(), null);
        }
    }

    public void log(int l, Object o, Throwable t) {
        if (!this.enable || !this.isLoggable(l)) {
            return;
        }
        if (this.categ != null) {
            this.categ.log((Priority)this.convertToLog4jLevel(l), o == null ? o : o.toString(), t);
        } else {
            this.forcedLog(instanceFQN, (Priority)this.convertToLog4jLevel(l), o == null ? o : o.toString(), t);
        }
    }

    public void log(Level l, Object o, Throwable t) {
        if (!this.enable || !this.isLoggable(l.getIntValue())) {
            return;
        }
        if (this.categ != null) {
            this.categ.log((Priority)this.convertToLog4jLevel(l.getIntValue()), o == null ? o : o.toString(), t);
        } else {
            this.forcedLog(instanceFQN, (Priority)this.convertToLog4jLevel(l.getIntValue()), o == null ? o : o.toString(), t);
        }
    }

    public void log(int l, Object o, Object location, Object method) {
        if (!this.enable || !this.isLoggable(l)) {
            return;
        }
        if (this.categ != null) {
            this.categ.log((Priority)this.convertToLog4jLevel(l), o == null ? o : o.toString(), null);
        } else {
            this.forcedLog(instanceFQN, (Priority)this.convertToLog4jLevel(l), (location == null ? "" : location.toString()) + (method == null ? "" : method.toString()) + (o == null ? o : o.toString()), null);
        }
    }

    public void log(Level l, Object o, Object location, Object method) {
        if (!this.enable || !this.isLoggable(l.getIntValue())) {
            return;
        }
        if (this.categ != null) {
            this.categ.log((Priority)this.convertToLog4jLevel(l.getIntValue()), o == null ? o : o.toString(), null);
        } else {
            this.forcedLog(instanceFQN, (Priority)this.convertToLog4jLevel(l.getIntValue()), (location == null ? "" : location.toString()) + (method == null ? "" : method.toString()) + (o == null ? o : o.toString()), null);
        }
    }

    public void log(int l, Object o, Throwable t, Object location, Object method) {
        if (!this.enable || !this.isLoggable(l)) {
            return;
        }
        if (this.categ != null) {
            this.categ.log((Priority)this.convertToLog4jLevel(l), o == null ? o : o.toString(), t);
        } else {
            this.forcedLog(instanceFQN, (Priority)this.convertToLog4jLevel(l), (location == null ? "" : location.toString()) + (method == null ? "" : method.toString()) + (o == null ? o : o.toString()), t);
        }
    }

    public void log(Level l, Object o, Throwable t, Object location, Object method) {
        if (!this.enable || !this.isLoggable(l.getIntValue())) {
            return;
        }
        if (this.categ != null) {
            this.categ.log((Priority)this.convertToLog4jLevel(l.getIntValue()), o == null ? o : o.toString(), t);
        } else {
            this.forcedLog(instanceFQN, (Priority)this.convertToLog4jLevel(l.getIntValue()), (location == null ? "" : location.toString()) + (method == null ? "" : method.toString()) + (o == null ? o : o.toString()), t);
        }
    }

    public void turnOn() {
        this.enable = true;
    }

    public void turnOff() {
        this.enable = false;
    }

    public void setIntLevel(int level) {
        if (level == BasicLevel.INHERIT) {
            if (this.categ != null) {
                this.categ.setLevel(null);
            } else {
                super.setLevel(null);
            }
            return;
        }
        if (this.categ != null) {
            this.categ.setLevel(this.convertToLog4jLevel(level));
        } else {
            super.setLevel(this.convertToLog4jLevel(level));
        }
    }

    public void setLevel(Level l) {
        if (l == null || l.getIntValue() == BasicLevel.INHERIT) {
            if (this.categ != null) {
                this.categ.setLevel(null);
            } else {
                super.setLevel(null);
            }
            return;
        }
        if (this.categ != null) {
            this.categ.setLevel(this.convertToLog4jLevel(l.getIntValue()));
        } else {
            super.setLevel(this.convertToLog4jLevel(l.getIntValue()));
        }
    }

    public int getCurrentIntLevel() {
        if (this.categ != null) {
            return this.categ.getLevel().toInt();
        }
        return this.level != null ? this.level.toInt() : BasicLevel.INHERIT;
    }

    public Level getCurrentLevel() {
        org.apache.log4j.Level p = null;
        p = this.categ != null ? this.categ.getLevel() : this.level;
        if (p != null) {
            return LevelImpl.getLevel(p.toInt());
        }
        return BasicLevel.LEVEL_INHERIT;
    }

    public void addHandler(Handler h) throws Exception {
        if (h instanceof Appender) {
            if (this.categ != null) {
                this.categ.addAppender((Appender)h);
            } else {
                super.addAppender((Appender)h);
            }
        } else {
            throw new UnsupportedOperationException("The type of the handler does not match with this wrapper");
        }
    }

    public void addTopic(String topic) throws Exception {
        if (this.categ == null) {
            Category p = this.parent;
            String n = this.name;
            Logger.getLogger((String)topic, (LoggerFactory)new BetaCF(this));
            this.topicToparents.put(topic, this.parent);
            this.parent = (Logger)p;
            this.name = n;
        }
    }

    public Handler[] getHandler() {
        ArrayList<Appender> al = new ArrayList<Appender>();
        if (this.categ != null) {
            Enumeration en = this.categ.getAllAppenders();
            while (en.hasMoreElements()) {
                Appender a = (Appender)en.nextElement();
                if (a instanceof Handler) {
                    al.add(a);
                    continue;
                }
                al.add(new GenericHandler(a));
            }
        } else {
            Enumeration en = this.getAllAppenders();
            while (en.hasMoreElements()) {
                Appender a = (Appender)en.nextElement();
                if (a instanceof Handler) {
                    al.add(a);
                    continue;
                }
                al.add(new GenericHandler(a));
            }
        }
        return al.toArray(new Handler[0]);
    }

    public Handler getHandler(String hn) {
        Appender a = null;
        a = this.categ != null ? this.categ.getAppender(hn) : this.getAppender(hn);
        if (a instanceof Handler) {
            return (Handler)a;
        }
        return new GenericHandler(a);
    }

    public void removeAllHandlers() throws Exception {
        if (this.categ != null) {
            this.categ.removeAllAppenders();
        } else {
            this.removeAllAppenders();
        }
    }

    public Enumeration getTopics() {
        return new EnumrationImpl((Object[])this.topicToparents.keySet().toArray(new String[0]));
    }

    public String[] getTopic() {
        String[] res = null;
        if (this.categ != null) {
            res = new String[]{AbstractFactory.getTopicWithoutPrefix((String)this.categ.getName())};
            return res;
        }
        res = new String[this.topicToparents.size() + 1];
        res[0] = AbstractFactory.getTopicWithoutPrefix((String)this.name);
        int i = 1;
        Iterator it = this.topicToparents.keySet().iterator();
        while (it.hasNext()) {
            res[i] = AbstractFactory.getTopicWithoutPrefix((String)((String)it.next()));
            ++i;
        }
        return res;
    }

    public void removeHandler(Handler h) throws Exception {
        if (h instanceof Appender) {
            if (this.categ != null) {
                this.categ.removeAppender((Appender)h);
                if (h instanceof GenericHandler) {
                    this.categ.removeAppender(((GenericHandler)h).getAppender());
                }
            } else {
                super.removeAppender((Appender)h);
                if (h instanceof GenericHandler) {
                    super.removeAppender(((GenericHandler)h).getAppender());
                }
            }
        } else {
            throw new UnsupportedOperationException("The type of the handler does not match with this wrapper");
        }
    }

    public void removeTopic(String topic) throws Exception {
        if (this.categ == null) {
            this.topicToparents.remove(topic);
        }
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getType() {
        return "logger";
    }

    public String[] getAttributeNames() {
        return new String[0];
    }

    public Object getAttribute(String name) {
        return null;
    }

    public Object setAttribute(String name, Object value) {
        return null;
    }

    public static class BetaCF
    implements LoggerFactory {
        MonologCategory mc = null;

        public BetaCF(MonologCategory mc) {
            this.mc = mc;
        }

        public Logger makeNewLoggerInstance(String name) {
            return this.mc;
        }
    }

    public static class OwPriority
    extends org.apache.log4j.Level {
        protected int level = 10000;

        public OwPriority(int l) {
            super(l, "INTER", l);
            this.level = l;
        }

        public boolean isGreaterOrEqual(Priority pr) {
            return this.level >= pr.toInt();
        }
    }
}

