/**
 * Copyright (C) 2001-2003 France Telecom R&D
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.objectweb.util.monolog.wrapper.log4j;

import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.PatternLayout;
import org.apache.log4j.net.SocketHubAppender;
import org.objectweb.util.monolog.api.Handler;
import org.objectweb.util.monolog.api.MonologFactory;
import org.objectweb.util.monolog.wrapper.common.AbstractFactory;
/**
 * This class is the wrapper to the org.apache.log4j.SocketHubAppender
 *
 * @author Sebastien Chassande-Barrioz, Olivier Beyler
 */
public class SocketHubHandler extends SocketHubAppender implements Handler {

	static final String PROPERTY_PORT="port";
	/**
	 * This fields contains the properties of the Handler
	 */
	protected HashMap prop = null;

	public SocketHubHandler() {
		super();
	}

	/**
	 * It Builds a new SocketHandler.
	 * @param name 	is the handler name.
	 */
	public SocketHubHandler(String name) {
		super();
		setName(name);
		prop = new HashMap();
	}

	public Map getAttributes() {
		return prop;
	}

	public void setAttributes(Map attributes) {
		prop.clear();
		prop.putAll(attributes);
		Object mf = prop.get("activation");
		if (mf != null) {
		    prop.remove("activation");
		    setAttribute("activation", mf);
		}
	}

	// IMPLEMENTATION OF THE Handler INTERFACE //
	//---------------------------------------------//

	public String getType() {
		return "file";
	}

	public String[] getAttributeNames() {
		return (String[]) prop.keySet().toArray(new String[0]);
	}

	public Object getAttribute(String key) {
		return prop.get(key);
	}

	public Object setAttribute(String key, Object value) {
		if (prop == null) {
			prop = new HashMap();
		}
		if (!key.equalsIgnoreCase("activation")) {
			return prop.put(key, value);
		} else if (prop.containsKey(key)) {
		    return null; //already activated
		}
		MonologFactory mf = (MonologFactory) value;
				
		String pattern = (String) prop.get(Handler.PATTERN_ATTRIBUTE);
		setLayout(new PatternLayout(PatternConverter.monolog2log4j(pattern)));

		String level = (String) prop.get(Handler.LEVEL_ATTRIBUTE);
		if (level != null && level.length() > 0) {
			int levelVal = org.objectweb.util.monolog.wrapper.common.LevelImpl.evaluate(level, mf);
			setThreshold(org.apache.log4j.Level.toLevel(levelVal));
		}
		String port =(String) prop.get(PROPERTY_PORT);
		if (port!=null){
			try {
				setPort(Integer.parseInt(port));
			} catch (NumberFormatException e) {
				AbstractFactory.warn("Invalif port definition ("+port+" on handler :"+name);
			}
		}
		
		super.activateOptions();
		return null;
	}
	

}
