/**
 * Copyright (C) 2001-2003 France Telecom R&D
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.objectweb.util.monolog.wrapper.log4j;

import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Level;
import org.objectweb.util.monolog.api.LevelFactory;

/**
 * This extension of the common LevelImpl provides conversion method for the
 * monolog levels to the log4j levels.
 * 
 * @author S.chassande-Barrioz
 */
public class LevelImpl
	extends org.objectweb.util.monolog.wrapper.common.LevelImpl {

	static public org.apache.log4j.Level convertLevel(
		org.objectweb.util.monolog.api.Level l) {
		return org.apache.log4j.Level.toLevel(l.getIntValue());
	}

	static public Level getLevel(int value) {
		if (value >= BasicLevel.FATAL) {
			return BasicLevel.LEVEL_FATAL;
		}
		else if (value >= BasicLevel.ERROR) {
			return BasicLevel.LEVEL_ERROR;
		}
		else if (value >= BasicLevel.WARN) {
			return BasicLevel.LEVEL_WARN;
		}
		else if (value >= BasicLevel.INFO) {
			return BasicLevel.LEVEL_INFO;
		}
		else if (value >= BasicLevel.DEBUG) {
			return BasicLevel.LEVEL_DEBUG;
		}
		else {
			return BasicLevel.LEVEL_DEBUG;
		}
	}

	public LevelImpl(String name, int val) {
		super(name, val);
	}

	public LevelImpl(String name, String val, LevelFactory lf) {
		super(name, val, lf);
	}

}
