/**
 * Copyright (C) 2001-2003 France Telecom R&D
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.objectweb.util.monolog.wrapper.log4j;

import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.PatternLayout;
import org.objectweb.util.monolog.api.Handler;
import org.objectweb.util.monolog.api.MonologFactory;
import org.objectweb.util.monolog.wrapper.common.RelatifEnvironmentPathGetter;

/**
 *
 * @author Sebastien Chassande-Barrioz
 */
public class ConsoleHandler extends ConsoleAppender implements Handler {

	/**
	 * This fields contains the properties of the Handler
	 */
	protected HashMap prop = null;

	public ConsoleHandler() {
		super();
	}

	/**
	 * It Builds a new ConsoleHandler.
	 * @param name 	is the handler name.
	 */
	public ConsoleHandler(String name) {
		super();
		setName(name);
		prop = new HashMap();
	}

	public Map getAttributes() {
		return prop;
	}

	public void setAttributes(Map attributes) {
		prop.clear();
		prop.putAll(attributes);
		Object mf = prop.get("activation");
		if (mf != null) {
		    prop.remove("activation");
		    setAttribute("activation", mf);
		}
	}

	// IMPLEMENTATION OF THE Handler INTERFACE //
	//---------------------------------------------//

	public String getType() {
		return "console";
	}

	public String[] getAttributeNames() {
		return (String[]) prop.keySet().toArray(new String[0]);
	}

	public Object getAttribute(String key) {
		return prop.get(key);
	}

	public Object setAttribute(String key, Object value) {
		if (prop == null)
			prop = new HashMap();
		if (!key.equalsIgnoreCase("activation")) {
			return prop.put(key, value);
		} else if (prop.containsKey(key)) {
		    return null; //already activated
		}
		MonologFactory mf = (MonologFactory) value;
		String pattern = (String) prop.get(Handler.PATTERN_ATTRIBUTE);
		if (pattern != null) {
		    setLayout(new PatternLayout(PatternConverter.monolog2log4j(pattern)));
		}
		String level = (String) prop.get(Handler.LEVEL_ATTRIBUTE);
		if (level != null && level.length() > 0) {
			int levelVal = org.objectweb.util.monolog.wrapper.common.LevelImpl.evaluate(level, mf);
			setThreshold(org.apache.log4j.Level.toLevel(levelVal));
		}
		String output = (String) prop.get(Handler.OUTPUT_ATTRIBUTE);
		output = RelatifEnvironmentPathGetter.getRealPath(output);
		if (output != null) {
			super.target = output;
			if (output.equalsIgnoreCase("System.out")) {
				setWriter(new OutputStreamWriter(System.out));
			} else if (output.equalsIgnoreCase("System.err")) {
				setWriter(new OutputStreamWriter(System.err));
			}
		}
		super.activateOptions();
		return null;
	}

}

