/**
 * Copyright (C) 2004 France Telecom R&D
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.objectweb.util.monolog.wrapper.javaLog;
import java.io.Writer;
import java.util.logging.ErrorManager;
import java.util.logging.LogRecord;

import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

import org.objectweb.util.monolog.wrapper.common.OutputStreamSwitcher;

/**
 * The aim of this class is to permit to specify the output for the console
 * handler of the java.util.logging system.
 *
 * This console handler is also able to choose the right ouput (System.err
 * or System.out) depending on the message level.
 *
 * @author S.Chassande-Barrioz
 */
public class JMXHandler extends java.util.logging.Handler implements NotificationEmitter {

	protected OutputStreamSwitcher oss;
	private Writer writer;

	public JMXHandler() {
		super();
	}
	
	CustomNotificationBroadcasterSupport emitter = new  CustomNotificationBroadcasterSupport();
	
	public void addNotificationListener(NotificationListener listener,
            NotificationFilter filter,
            Object handback)
            throws IllegalArgumentException {
		emitter.addNotificationListener(listener, filter, handback);
	}
	
	public void removeNotificationListener( NotificationListener listener )
    throws ListenerNotFoundException {
		emitter.removeNotificationListener( listener );
	}
	
	public void removeNotificationListener( NotificationListener listener, 
			NotificationFilter filter, Object handback) 
			throws ListenerNotFoundException {
		emitter.removeNotificationListener( listener, filter, handback );
	}
	
	public MBeanNotificationInfo[] getNotificationInfo(){
		return emitter.getNotificationInfo();
	}

	private long notificationSequence = 0 ;
	
	public void publish(LogRecord record) {
		if (!isLoggable(record)) {
			return;
		}
		String msg = record.getMessage();
		Notification notification = new Notification ("Monolog.JMXHandler.Log",
				"JMXHandler:Type=javaLog",++notificationSequence,
				System.currentTimeMillis(), msg );
		notification.setUserData(record);
		emitter.sendNotification(notification);
	}

	class CustomNotificationBroadcasterSupport extends NotificationBroadcasterSupport {
		public void sendNotification (Notification notification) {
			super.sendNotification (notification);	
		}
		public void addNotificationListener(NotificationListener listener,
	            NotificationFilter filter,
	            Object handback)
	            throws IllegalArgumentException {
				super.addNotificationListener(listener, filter, handback);
				
		}
	}

	public void flush() {
		if (writer != null) {
			try {
				writer.flush();
			} catch (Exception ex) {
				// We don't want to throw an exception here, but we
				// report the exception to any registered ErrorManager.
				reportError(null, ex, ErrorManager.FLUSH_FAILURE);
			}
		}
	}

	public void close() throws SecurityException {
		flush();
	}
}
