/**
 * Copyright (C) 2001-2003 France Telecom R&D
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.objectweb.util.monolog.wrapper.javaLog;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;


/**
 * Is a generic handler implementation used to wrapper java.util.logging.Handler
 * instance.
 * @author S.Chassande-Barrioz
 */
public class JMXGenericHandler
        extends GenericHandler
        implements NotificationEmitter {
	
	public JMXGenericHandler() {
		super();
        type = "jmx";
	}
	
	public void addNotificationListener(NotificationListener listener,
            NotificationFilter filter,
            Object handback)
            throws IllegalArgumentException {
		((NotificationEmitter)handler).addNotificationListener( listener, filter, handback );
	}
	
	public void removeNotificationListener( NotificationListener listener )
    throws ListenerNotFoundException {
		((NotificationEmitter)handler).removeNotificationListener( listener );
	}
	
	public void removeNotificationListener( NotificationListener listener, 
			NotificationFilter filter, Object handback) 
			throws ListenerNotFoundException {
		((NotificationEmitter)handler).removeNotificationListener( listener, filter, handback );
	}
	
	public MBeanNotificationInfo[] getNotificationInfo(){
		return ((NotificationEmitter)handler).getNotificationInfo();
	}
}