/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.joram.shell;

public class ShellDisplay {
    static void displayTable(String[][] table) {
        ShellDisplay.displayTable(table, false);
    }

    public static void displayTable(String[][] table, boolean header) {
        if (table == null || table.length == 0 || table[0].length == 0) {
            return;
        }
        int nbRow = table.length;
        int nbCol = table[0].length;
        for (int i = 1; i < nbRow; ++i) {
            if (table[i].length == nbCol) continue;
            System.err.println("Error: Invalid table.");
            return;
        }
        boolean lineheader = header;
        int[] maxWidth = new int[nbCol];
        for (int c = 0; c < nbCol; ++c) {
            for (int r = 0; r < nbRow; ++r) {
                try {
                    if (r != 0 && maxWidth[c] >= table[r][c].length()) continue;
                    maxWidth[c] = table[r][c].length();
                    continue;
                }
                catch (NullPointerException e) {
                    System.err.println("Null pointer exception");
                    System.err.println("table[" + r + "][" + c + "] = " + table[r][c] == null ? "null" : table[r][c]);
                    return;
                }
            }
        }
        for (int r = 0; r < nbRow; ++r) {
            for (int c = 0; c < nbCol; ++c) {
                int i;
                if (lineheader && r == 1) {
                    for (i = 0; c < nbCol - 1 && i < maxWidth[c] + 3 || i < maxWidth[c]; ++i) {
                        if (i == maxWidth[c] + 1) {
                            System.out.print('+');
                            continue;
                        }
                        System.out.print('-');
                    }
                    if (c == nbCol - 1) {
                        --r;
                        lineheader = false;
                    }
                } else {
                    System.out.print(table[r][c]);
                    for (i = table[r][c].length(); i < maxWidth[c]; ++i) {
                        System.out.print(" ");
                    }
                }
                if (header && c != nbCol - 1 && (r != 1 || !lineheader)) {
                    System.out.print(" ! ");
                    continue;
                }
                if (lineheader || c == nbCol - 1) continue;
                System.out.print("\t");
            }
            System.out.println();
        }
    }
}

