/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.joram.shell.jndi.commands;

import fr.dyade.aaa.jndi2.impl.NamingContextMBean;
import java.util.Properties;
import javax.naming.NamingException;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.ow2.joram.shell.jndi.commands.JNDICommands;

public class JNDICommandsImpl
implements JNDICommands {
    private static final int TIMEOUT = 1000;
    public static final String NAMESPACE = "joram:jndi";
    public static final String[] COMMANDS = new String[]{"list"};
    private BundleContext bundleContext;
    private ServiceTracker tracker;

    public JNDICommandsImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.tracker = new ServiceTracker(this.bundleContext, NamingContextMBean.class.getCanonicalName(), null);
        this.tracker.open();
    }

    @Override
    public void getNamingContext() {
        try {
            NamingContextMBean nc = (NamingContextMBean)this.tracker.waitForService(1000L);
            if (nc != null) {
                String[] names = nc.getNamingContext();
                if (names != null && names.length > 0) {
                    System.out.println("Naming context:");
                    for (String n : names) {
                        System.out.println("\t" + n);
                    }
                } else {
                    System.out.println("No name in the naming context.");
                }
            } else {
                System.err.println("Error: No NamingContextMBean service found.");
            }
        }
        catch (InterruptedException e) {
            System.err.println("Error: Interrupted.");
        }
    }

    @Override
    public void getStrOwnerId() {
        try {
            NamingContextMBean nc = (NamingContextMBean)this.tracker.waitForService(1000L);
            if (nc != null) {
                System.out.println(nc.getStrOwnerId());
            } else {
                System.err.println("Error: No NamingContextMBean service found.");
            }
        }
        catch (InterruptedException e) {
            System.err.println("Error: Interrupted.");
        }
    }

    @Override
    public void setStrOwnerId(String strOwnerId) {
        try {
            NamingContextMBean nc = (NamingContextMBean)this.tracker.waitForService(1000L);
            if (nc != null) {
                nc.setStrOwnerId(strOwnerId);
            } else {
                System.err.println("Error: No NamingContextMBean service found.");
            }
        }
        catch (InterruptedException e) {
            System.err.println("Error: Interrupted.");
        }
    }

    @Override
    public void createSubcontext(String ctxName) {
        try {
            NamingContextMBean nc = (NamingContextMBean)this.tracker.waitForService(1000L);
            if (nc != null) {
                nc.createSubcontext(ctxName);
            } else {
                System.err.println("Error: No NamingContextMBean service found.");
            }
        }
        catch (InterruptedException e) {
            System.err.println("Error: Interrupted.");
        }
        catch (NamingException e) {
            System.err.println("Error: Invalid subcontext name.");
        }
    }

    @Override
    public void destroySubcontext() {
        try {
            NamingContextMBean nc = (NamingContextMBean)this.tracker.waitForService(1000L);
            if (nc != null) {
                nc.destroySubcontext();
            } else {
                System.err.println("Error: No NamingContextMBean service found.");
            }
        }
        catch (InterruptedException e) {
            System.err.println("Error: Interrupted.");
        }
        catch (NamingException e) {
            System.err.println("Error: Invalid subcontext name.");
        }
    }

    @Override
    public void lookup(String name) {
        try {
            NamingContextMBean nc = (NamingContextMBean)this.tracker.waitForService(1000L);
            if (nc != null) {
                System.out.println(nc.lookup(name));
            } else {
                System.err.println("Error: No NamingContextMBean service found.");
            }
        }
        catch (InterruptedException e) {
            System.err.println("Error: Interrupted.");
        }
        catch (NamingException e) {
            System.err.println("Error: Invalid record name.");
        }
    }

    @Override
    public void unbind(String name) {
        try {
            NamingContextMBean nc = (NamingContextMBean)this.tracker.waitForService(1000L);
            if (nc != null) {
                nc.unbind(name);
            } else {
                System.err.println("Error: No NamingContextMBean service found.");
            }
        }
        catch (InterruptedException e) {
            System.err.println("Error: Interrupted.");
        }
        catch (NamingException e) {
            System.err.println("Error: Invalid record name.");
        }
    }

    public void list() {
        try {
            NamingContextMBean nc = (NamingContextMBean)this.tracker.waitForService(1000L);
            for (String name : nc.getNamingContext()) {
                try {
                    System.out.println(name + ":");
                    Properties prop = nc.getProperties(name);
                    for (String key : prop.stringPropertyNames()) {
                        System.out.println("\t" + key + " : " + prop.getProperty(key));
                    }
                }
                catch (NamingException e) {
                    System.err.println("Error: Naming exception.");
                }
            }
        }
        catch (InterruptedException e) {
            System.err.println("Error: Interrupted.");
        }
    }
}

