/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.joram.shell.a3.commands;

import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.EngineMBean;
import fr.dyade.aaa.agent.NetworkMBean;
import fr.dyade.aaa.ext.NGTransactionMBean;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.util.tracker.ServiceTracker;
import org.ow2.joram.shell.a3.commands.A3Commands;

public class A3CommandsImpl
implements A3Commands {
    public static final String NAMESPACE = "joram:a3";
    private static final int TIMEOUT = 1000;
    public static final String AGENT_SERVER_ID_PROPERTY = "fr.dyade.aaa.agent.AgentServer.id";
    public static final String AGENT_SERVER_CLUSTERID_PROPERTY = "fr.dyade.aaa.agent.AgentServer.clusterid";
    public static final String AGENT_SERVER_STORAGE_PROPERTY = "fr.dyade.aaa.agent.AgentServer.storage";
    public static final String[] COMMANDS = new String[]{"engineLoad", "garbageRatio", "restartServer", "startServer", "stopServer", "close", "info"};
    private BundleContext bundleContext;
    private ServiceTracker engineTracker;
    private ServiceTracker ngtTracker;
    private ServiceTracker networkTracker;

    public A3CommandsImpl(BundleContext context) {
        this.bundleContext = context;
        this.engineTracker = new ServiceTracker(this.bundleContext, EngineMBean.class.getCanonicalName(), null);
        this.ngtTracker = new ServiceTracker(this.bundleContext, NGTransactionMBean.class.getCanonicalName(), null);
        this.networkTracker = new ServiceTracker(this.bundleContext, NetworkMBean.class.getCanonicalName(), null);
        this.engineTracker.open();
        this.ngtTracker.open();
        this.networkTracker.open();
    }

    @Override
    public void engineLoad(String[] args) {
        EngineMBean engine = this.getEngine();
        if (engine == null) {
            System.err.println("Error: No engine found.");
            return;
        }
        float load = engine.getAverageLoad1();
        System.out.println("Engine load (for the last min.): " + load);
    }

    @Override
    public void garbageRatio(String[] args) {
        NGTransactionMBean ngt;
        try {
            ngt = (NGTransactionMBean)this.ngtTracker.waitForService(1000L);
        }
        catch (InterruptedException e) {
            System.err.println("Error: Interrupted.");
            ngt = null;
        }
        if (ngt == null) {
            System.err.println("Error: No NG transaction found.");
            return;
        }
        float load = ngt.getGarbageRatio();
        System.out.println("Garbage operations ratio: " + load);
    }

    @Override
    public void stopServer() {
        System.out.print("Server stopping... ");
        System.out.flush();
        AgentServer.stop();
        AgentServer.reset();
        System.out.println("Done.");
    }

    @Override
    public void startServer() {
        short sid = this.getShortProperty(AGENT_SERVER_ID_PROPERTY, (short)0);
        String path = this.getProperty(AGENT_SERVER_STORAGE_PROPERTY, "s" + sid);
        System.out.print("Server starting... ");
        System.out.flush();
        try {
            LoggerFactory f = null;
            AgentServer.init((short)sid, (String)path, f);
            AgentServer.start();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
        System.out.println("Started.");
    }

    @Override
    public void restartServer() {
        this.stopServer();
        this.startServer();
    }

    @Override
    public void close() {
        this.stopServer();
        Bundle bundle0 = this.bundleContext.getBundle(0L);
        try {
            bundle0.stop();
        }
        catch (BundleException e) {
            System.err.println("Error: Failed to stop the System Bundle.");
            e.printStackTrace();
        }
    }

    @Override
    public void info(String[] args) {
        NGTransactionMBean ngt;
        NetworkMBean net;
        EngineMBean engine;
        boolean all = false;
        boolean isNgt = false;
        boolean isNet = false;
        boolean isEngine = false;
        for (String arg : args) {
            isEngine |= arg.equals("-eng");
            isNet |= arg.equals("-net");
            isNgt |= arg.equals("-ngt");
        }
        if (!(isEngine || isNet || isNgt)) {
            all = true;
        }
        if ((engine = this.getEngine()) != null && (isEngine || all)) {
            System.out.println("Engine: " + engine.getName());
            System.out.println("\tAvg. load over the last min.    : " + engine.getAverageLoad1());
            System.out.println("\tAvg. load over the last 5 min.  : " + engine.getAverageLoad5());
            System.out.println("\tAvg. load over the last 15 min. : " + engine.getAverageLoad15());
            System.out.println("\tNumber of waiting messages      : " + engine.getNbWaitingMessages());
        } else if (engine == null) {
            System.err.println("Error: Can't find A3 engine.");
        }
        NetworkMBean networkMBean = net = isNet ? this.getNetwork() : null;
        if (net != null && (isNet || all)) {
            System.out.println("Network: " + net.getName());
            System.out.println("\tNb waiting messages             : " + net.getNbWaitingMessages());
            System.out.println("\tAvg. load over the last min.    : " + net.getAverageLoad1());
            System.out.println("\tAvg. load over the last 5 min.  : " + net.getAverageLoad1());
            System.out.println("\tAvg. load over the last 15 min. : " + net.getAverageLoad1());
        } else if (isNet && net == null) {
            System.err.println("Error: Can't find the pool network service.");
        }
        NGTransactionMBean nGTransactionMBean = ngt = isNgt ? this.getNGTransaction() : null;
        if (ngt != null && (isNgt || all)) {
            System.out.println("NG Transaction:");
            System.out.println("\tGarbage ratio : " + ngt.getGarbageRatio());
        } else if (isNgt && ngt == null) {
            System.err.println("Error: Can't find the NG Transaction service.");
        }
    }

    private EngineMBean getEngine() {
        try {
            return (EngineMBean)this.engineTracker.waitForService(1000L);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    private NGTransactionMBean getNGTransaction() {
        try {
            return (NGTransactionMBean)this.ngtTracker.waitForService(1000L);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    private NetworkMBean getNetwork() {
        try {
            return (NetworkMBean)this.networkTracker.waitForService(1000L);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    private String getProperty(String prop, String defaultVal) {
        String val = this.bundleContext.getProperty(prop);
        if (val != null) {
            return val;
        }
        return defaultVal;
    }

    private Short getShortProperty(String prop, Short defaultVal) {
        String val = this.bundleContext.getProperty(prop);
        try {
            if (val != null) {
                return Short.parseShort(val);
            }
            return defaultVal;
        }
        catch (NumberFormatException e) {
            return defaultVal;
        }
    }
}

