/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.jndi2.distributed;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.jndi2.distributed.ReplicationEntryPoint;
import fr.dyade.aaa.jndi2.distributed.ReplicationManager;
import fr.dyade.aaa.jndi2.server.AgentEntryPoint;
import fr.dyade.aaa.jndi2.server.Container;
import fr.dyade.aaa.jndi2.server.TcpEntryPoint;
import fr.dyade.aaa.jndi2.server.TcpServer;
import fr.dyade.aaa.jndi2.server.Trace;
import java.net.ServerSocket;
import java.util.StringTokenizer;
import java.util.Vector;
import org.objectweb.util.monolog.api.BasicLevel;

public class DistributedJndiServer {
    private static TcpServer tcpServer;

    public static void init(String args, boolean firstTime) throws Exception {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("DistributedJndiServer.init(" + args + ',' + firstTime + ')'));
        }
        StringTokenizer st = new StringTokenizer(args);
        String portS = st.nextToken();
        int port = Integer.parseInt(portS);
        Vector<Short> list = new Vector<Short>();
        while (st.hasMoreTokens()) {
            String idS = st.nextToken();
            Short id = Short.valueOf(idS);
            list.addElement(id);
        }
        short[] serverIds = new short[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            serverIds[i] = (Short)list.elementAt(i);
        }
        ServerSocket serverSocket = new ServerSocket(port);
        int poolSize = AgentServer.getInteger((String)"fr.dyade.aaa.jndi2.server.poolSize", (int)3);
        int timeout = AgentServer.getInteger((String)"fr.dyade.aaa.jndi2.server.soTimeout", (int)10000);
        tcpServer = new TcpServer(serverSocket, poolSize, timeout, DistributedJndiServer.getDefault());
        if (firstTime) {
            ReplicationManager manager = new ReplicationManager(serverIds);
            AgentEntryPoint agentEP = new AgentEntryPoint();
            agentEP.setRequestManager(manager);
            TcpEntryPoint tcpEP = new TcpEntryPoint();
            tcpEP.setRequestManager(manager);
            ReplicationEntryPoint replicationEP = new ReplicationEntryPoint();
            replicationEP.setRequestManager(manager);
            Container container = new Container();
            container.addEntryPoint(agentEP);
            container.addEntryPoint(tcpEP);
            container.addEntryPoint(replicationEP);
            container.setLifeCycleListener(manager);
            manager.setContainer(container);
            container.deploy();
        }
        tcpServer.start();
    }

    public static void stopService() {
        tcpServer.stop();
    }

    public static AgentId getDefault() {
        return DistributedJndiServer.getDefault(AgentServer.getServerId());
    }

    public static AgentId getDefault(short serverId) {
        return new AgentId(serverId, serverId, AgentId.LocalJndiServiceStamp);
    }
}

