/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.wrapper.javaLog;

import java.io.Writer;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import org.objectweb.util.monolog.wrapper.common.OutputStreamSwitcher;

public class JMXHandler
extends Handler
implements NotificationEmitter {
    protected OutputStreamSwitcher oss;
    private Writer writer;
    CustomNotificationBroadcasterSupport emitter = new CustomNotificationBroadcasterSupport();
    private long notificationSequence = 0L;

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.emitter.addNotificationListener(listener, filter, handback);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(listener);
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(listener, filter, handback);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.emitter.getNotificationInfo();
    }

    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        String msg = record.getMessage();
        Notification notification = new Notification("Monolog.JMXHandler.Log", "JMXHandler:Type=javaLog", ++this.notificationSequence, System.currentTimeMillis(), msg);
        notification.setUserData(record);
        this.emitter.sendNotification(notification);
    }

    public void flush() {
        if (this.writer != null) {
            try {
                this.writer.flush();
            }
            catch (Exception ex) {
                this.reportError(null, ex, 2);
            }
        }
    }

    public void close() throws SecurityException {
        this.flush();
    }

    class CustomNotificationBroadcasterSupport
    extends NotificationBroadcasterSupport {
        CustomNotificationBroadcasterSupport() {
        }

        public void sendNotification(Notification notification) {
            super.sendNotification(notification);
        }

        public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
            super.addNotificationListener(listener, filter, handback);
        }
    }
}

