/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.wrapper.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Handler;
import org.objectweb.util.monolog.api.Level;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.MonologFactory;
import org.objectweb.util.monolog.api.MonologFactoryListener;
import org.objectweb.util.monolog.wrapper.common.Configurable;
import org.objectweb.util.monolog.wrapper.common.LevelImpl;

public abstract class AbstractFactory
implements MonologFactory,
Configurable {
    public static final String CLASSLOADER_ISOLATION = "monolog.isolateclassloader";
    public static String[] handlerTypes = new String[]{"console", "file", "rollingfile", "ntevent", "jmx", "sockethub", "generic"};
    public static String[][] handlerType2className = null;
    public static boolean classLoaderIsoltion = Boolean.getBoolean("monolog.isolateclassloader");
    public static boolean debug = Boolean.getBoolean("monolog.debug");
    protected static String rootLoggerPrefix = null;
    protected static String rootLoggerName = null;
    protected String resourceBundleName = null;
    protected Map nameToLevel = null;
    protected Map intToNames = new HashMap();
    protected Map handlers = null;
    protected Collection monologFactoryListeners = null;

    public static String getRootLoggerPrefix() {
        return rootLoggerPrefix;
    }

    public static String getTopicWithoutPrefix(String topic) {
        if (classLoaderIsoltion && rootLoggerPrefix != null && topic.startsWith(rootLoggerPrefix)) {
            return topic.substring(rootLoggerPrefix.length());
        }
        return topic;
    }

    protected static String monoLoggerName(String name) {
        if (classLoaderIsoltion) {
            if (name.startsWith(rootLoggerPrefix)) {
                if (debug) {
                    AbstractFactory.debug("name already prefixed: " + name);
                }
                return name;
            }
            return rootLoggerPrefix + name;
        }
        return name;
    }

    public static void debug(String m) {
        if (debug) {
            System.out.println(m);
        }
    }

    public static void warn(String m) {
        System.err.println("WARN: " + m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractFactory() {
        this.nameToLevel = new HashMap();
        this.handlers = new HashMap();
        this.monologFactoryListeners = new HashSet();
        this.defineLevel(BasicLevel.LEVEL_INHERIT);
        this.defineLevel(BasicLevel.LEVEL_DEBUG);
        this.defineLevel(BasicLevel.LEVEL_INFO);
        this.defineLevel(BasicLevel.LEVEL_WARN);
        this.defineLevel(BasicLevel.LEVEL_ERROR);
        this.defineLevel(BasicLevel.LEVEL_FATAL);
        if (handlerType2className == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (handlerType2className == null) {
                    this.initHandlerType2className();
                }
            }
        }
    }

    public abstract String getWrapperName();

    protected void initHandlerType2className() {
        handlerType2className = this.getDefaultHandlerType2className();
        for (int i = 0; i < handlerType2className.length; ++i) {
            AbstractFactory.handlerTypes[i] = handlerType2className[i][0];
        }
        String hts = System.getProperty("monolog." + this.getWrapperName() + ".handlerTypes");
        if (hts != null && hts.length() > 0) {
            StringTokenizer st = new StringTokenizer(hts, ",;:|.", false);
            HashMap<String, String> m = null;
            if (st.hasMoreTokens()) {
                m = new HashMap<String, String>();
            }
            while (st.hasMoreTokens()) {
                String ht = st.nextToken();
                String hcn = System.getProperty("monolog.handlerType." + ht);
                if (hcn != null && hcn.length() > 0) {
                    m.put(ht, hcn);
                    continue;
                }
                AbstractFactory.debug("Handler type '" + ht + "' not well defined: " + hcn);
            }
            if (m != null && m.size() > 0) {
                String[] newHT = new String[handlerTypes.length + m.size()];
                System.arraycopy(handlerTypes, 0, newHT, 0, handlerTypes.length);
                String[][] newHT2CN = new String[handlerTypes.length + m.size()][];
                System.arraycopy(handlerType2className, 0, newHT2CN, 0, handlerType2className.length);
                int i = handlerTypes.length;
                for (Map.Entry me : m.entrySet()) {
                    AbstractFactory.handlerTypes[i] = (String)me.getKey();
                    AbstractFactory.handlerType2className[i][0] = handlerTypes[i];
                    AbstractFactory.handlerType2className[i][1] = (String)me.getValue();
                }
                handlerTypes = newHT;
                handlerType2className = newHT2CN;
            }
        }
    }

    protected abstract String[][] getDefaultHandlerType2className();

    private Level defineLevel(Level l) {
        String name = l.getName();
        int value = l.getIntValue();
        Level res = (Level)this.nameToLevel.get(name);
        if (res != null) {
            return res.getIntValue() == value ? res : null;
        }
        res = l;
        this.nameToLevel.put(name, res);
        Integer i = new Integer(value);
        Object temp = this.intToNames.get(i);
        if (temp != null) {
            ArrayList<Object> al;
            if (temp instanceof String) {
                if (!((String)temp).equalsIgnoreCase(name)) {
                    al = new ArrayList<Object>(5);
                    al.add(temp);
                    al.add(name);
                    this.intToNames.put(i, al);
                }
            } else if (temp instanceof ArrayList && !(al = (ArrayList<Object>)temp).contains(name)) {
                al.add(name);
            }
        } else {
            this.intToNames.put(i, name);
        }
        for (MonologFactoryListener mfl : this.monologFactoryListeners) {
            mfl.levelCreated(res);
        }
        return res;
    }

    public abstract void configure(Properties var1) throws Exception;

    public abstract Logger getLogger(String var1);

    public abstract Logger[] getLoggers();

    public String getTopicPrefix() {
        return rootLoggerPrefix;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public void setResourceBundleName(String rbn) {
        this.resourceBundleName = rbn;
    }

    public Handler createHandler(String hn, String handlertype) {
        int i;
        Handler res = (Handler)this.handlers.get(hn);
        if (res != null) {
            return res;
        }
        if (handlertype == null) {
            return null;
        }
        for (i = 0; i < handlerType2className.length && !handlerType2className[i][0].equalsIgnoreCase(handlertype); ++i) {
        }
        String handlerClassName = i < handlerType2className.length ? handlerType2className[i][1] : handlertype;
        AbstractFactory.debug("Instanciating the handler '" + hn + "', class name=" + handlerClassName);
        try {
            res = (Handler)Class.forName(handlerClassName).newInstance();
        }
        catch (Throwable e) {
            AbstractFactory.warn("Impossible to instanciate the handler: name=" + hn + ", class name=" + handlerClassName + ": " + e.getMessage());
            e.printStackTrace(System.err);
            return null;
        }
        res.setAttribute("handlertype", handlertype);
        res.setName(hn);
        this.handlers.put(hn, res);
        for (MonologFactoryListener mfl : this.monologFactoryListeners) {
            mfl.handlerCreated(res);
        }
        return res;
    }

    public Handler[] getHandlers() {
        return this.handlers.values().toArray(new Handler[0]);
    }

    public Handler getHandler(String hn) {
        return (Handler)this.handlers.get(hn);
    }

    public Handler removeHandler(String hn) {
        Handler res = (Handler)this.handlers.remove(hn);
        if (res != null) {
            for (MonologFactoryListener mfl : this.monologFactoryListeners) {
                mfl.handlerRemoved(this.getHandler(hn));
            }
        }
        return res;
    }

    public Level defineLevel(String name, int value) {
        return this.defineLevel(new LevelImpl(name, value));
    }

    public Level defineLevel(String name, String value) {
        return this.defineLevel(new LevelImpl(name, value, this));
    }

    public Level getLevel(String name) {
        return (Level)this.nameToLevel.get(name);
    }

    public Level getLevel(int value) {
        Object temp = this.intToNames.get(new Integer(value));
        if (temp == null) {
            return null;
        }
        if (temp instanceof String) {
            return this.getLevel((String)temp);
        }
        if (temp instanceof ArrayList) {
            return this.getLevel((String)((ArrayList)temp).get(0));
        }
        return null;
    }

    public Level[] getLevels() {
        return this.nameToLevel.values().toArray(new Level[0]);
    }

    public void removeLevel(String name) {
        Level removed = (Level)this.nameToLevel.remove(name);
        if (removed != null) {
            Integer i = new Integer(removed.getIntValue());
            Object temp = this.intToNames.get(i);
            if (temp instanceof String) {
                this.intToNames.remove(i);
            } else if (temp instanceof ArrayList) {
                ((ArrayList)temp).remove(name);
            }
            for (MonologFactoryListener mfl : this.monologFactoryListeners) {
                mfl.levelRemoved(removed);
            }
        }
    }

    public void addMonologFactoryListener(MonologFactoryListener mfl) {
        this.monologFactoryListeners.add(mfl);
    }

    public void removeMonologFactoryListener(MonologFactoryListener mfl) {
        this.monologFactoryListeners.remove(mfl);
    }
}

