/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.util;

import fr.dyade.aaa.util.AbstractTransaction;
import fr.dyade.aaa.util.BaseTransaction;
import fr.dyade.aaa.util.NTransactionMBean;
import fr.dyade.aaa.util.Operation;
import fr.dyade.aaa.util.OperationKey;
import fr.dyade.aaa.util.Repository;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import org.objectweb.util.monolog.api.BasicLevel;

public final class NTransaction
extends AbstractTransaction
implements NTransactionMBean {
    static int LogMemoryCapacity = 4096;
    static int MaxLogMemorySize = 0x200000;
    static int MaxLogFileSize = 0x1000000;
    boolean syncOnWrite = false;
    static int LogThresholdOperation = 1000;
    private Timer timer = null;
    private GarbageTask task = null;
    String repositoryImpl = "fr.dyade.aaa.util.FileRepository";
    LogFile logFile = null;
    Repository repository = null;
    static final boolean debug = false;

    @Override
    public final int getLogMemoryCapacity() {
        return LogMemoryCapacity;
    }

    @Override
    public final int getMaxLogMemorySize() {
        return MaxLogMemorySize / 1024;
    }

    @Override
    public final void setMaxLogMemorySize(int size) {
        if (size > 0) {
            MaxLogMemorySize = size * 1024;
        }
    }

    @Override
    public final int getLogMemorySize() {
        return this.logFile.logMemorySize;
    }

    @Override
    public final int getMaxLogFileSize() {
        return MaxLogFileSize / 0x100000;
    }

    @Override
    public final void setMaxLogFileSize(int size) {
        if (size > 0) {
            MaxLogFileSize = size * 0x100000;
        }
    }

    @Override
    public final int getLogFileSize() {
        return this.logFile.getLogFileSize() / 1024;
    }

    @Override
    public boolean isSyncOnWrite() {
        return this.syncOnWrite;
    }

    @Override
    public final int getLogThresholdOperation() {
        return LogThresholdOperation;
    }

    @Override
    public final int getCommitCount() {
        return this.logFile.commitCount;
    }

    @Override
    public final int getGarbageCount() {
        return this.logFile.garbageCount;
    }

    @Override
    public final int getGarbageDelay() {
        return (int)(this.logFile.garbageTimeOut / 1000L);
    }

    @Override
    public final void setGarbageDelay(int timeout) {
        this.logFile.garbageTimeOut = (long)timeout * 1000L;
    }

    @Override
    public final boolean isGarbageRunning() {
        return false;
    }

    @Override
    public void garbageAsync(boolean async) {
        if (async) {
            if (this.task == null) {
                this.task = new GarbageTask();
            }
        } else {
            if (this.task != null) {
                this.task.cancel();
            }
            this.task = null;
            if (this.timer != null) {
                this.timer.cancel();
            }
            this.timer = null;
        }
    }

    @Override
    public long getGarbageTime() {
        return this.logFile.garbageTime;
    }

    @Override
    public int getGarbageRatio() {
        return (int)(this.logFile.garbageTime * 100L / (System.currentTimeMillis() - this.startTime));
    }

    @Override
    public String getRepositoryImpl() {
        return this.repositoryImpl;
    }

    @Override
    public int getNbSavedObjects() {
        return this.repository.getNbSavedObjects();
    }

    @Override
    public int getNbDeletedObjects() {
        return this.repository.getNbDeletedObjects();
    }

    @Override
    public int getNbBadDeletedObjects() {
        return this.repository.getNbBadDeletedObjects();
    }

    @Override
    public int getNbLoadedObjects() {
        return this.repository.getNbLoadedObjects();
    }

    @Override
    public final void initRepository() throws IOException {
        LogMemoryCapacity = this.getInteger("NTLogMemoryCapacity", LogMemoryCapacity);
        MaxLogFileSize = this.getInteger("NTLogFileSize", MaxLogFileSize / 0x100000) * 0x100000;
        MaxLogMemorySize = this.getInteger("NTLogMemorySize", MaxLogMemorySize / 1024) * 1024;
        LogThresholdOperation = this.getInteger("NTLogThresholdOperation", LogThresholdOperation);
        Operation.initPool(LogThresholdOperation);
        this.syncOnWrite = this.getBoolean("Transaction.SyncOnWrite");
        try {
            this.repositoryImpl = System.getProperty("NTRepositoryImpl", this.repositoryImpl);
            this.repository = (Repository)Class.forName(this.repositoryImpl).newInstance();
            this.repository.init(this, this.dir);
        }
        catch (ClassNotFoundException exc) {
            logmon.log(BasicLevel.FATAL, (Object)"NTransaction, cannot initializes the repository ", (Throwable)exc);
            throw new IOException(exc.getMessage());
        }
        catch (InstantiationException exc) {
            logmon.log(BasicLevel.FATAL, (Object)"NTransaction, cannot initializes the repository ", (Throwable)exc);
            throw new IOException(exc.getMessage());
        }
        catch (IllegalAccessException exc) {
            logmon.log(BasicLevel.FATAL, (Object)"NTransaction, cannot initializes the repository ", (Throwable)exc);
            throw new IOException(exc.getMessage());
        }
        this.logFile = new LogFile(this.dir, this.repository, this.syncOnWrite);
        this.setGarbageDelay(this.getInteger("NTGarbageDelay", this.getGarbageDelay()));
        this.garbageAsync(this.getBoolean("NTAsyncGarbage"));
    }

    public String getPersistenceDir() {
        return this.dir.getPath();
    }

    @Override
    protected final void setPhase(int newPhase) {
        this.phase = newPhase;
    }

    @Override
    public synchronized String[] getList(String prefix) {
        int i;
        String[] list1 = null;
        try {
            list1 = this.repository.list(prefix);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (list1 == null) {
            list1 = new String[]{};
        }
        Object[] list2 = this.logFile.log.keySet().toArray();
        int nb = list1.length;
        for (int i2 = 0; i2 < list2.length; ++i2) {
            if (list2[i2] instanceof String && ((String)list2[i2]).startsWith(prefix)) {
                int j;
                for (j = 0; j < list1.length && !list2[i2].equals(list1[j]); ++j) {
                }
                if (j < list1.length) {
                    if (this.logFile.log.get((Object)list2[i2]).type == 2) {
                        list1[j] = null;
                        --nb;
                    }
                    list2[i2] = null;
                    continue;
                }
                if (this.logFile.log.get((Object)list2[i2]).type == 1 || this.logFile.log.get((Object)list2[i2]).type == 4) {
                    ++nb;
                    continue;
                }
                list2[i2] = null;
                continue;
            }
            list2[i2] = null;
        }
        String[] list = new String[nb];
        for (i = list1.length - 1; i >= 0; --i) {
            if (list1[i] == null) continue;
            list[--nb] = list1[i];
        }
        for (i = list2.length - 1; i >= 0; --i) {
            if (list2[i] == null) continue;
            list[--nb] = (String)list2[i];
        }
        return list;
    }

    @Override
    protected final void saveInLog(byte[] buf, String dirName, String name, Hashtable log, boolean copy, boolean first) throws IOException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("NTransaction, saveInLog(" + dirName + '/' + name + ", " + copy + ", " + first + ")"));
        }
        Object key = OperationKey.newKey(dirName, name);
        Operation op = null;
        op = first ? Operation.alloc(4, dirName, name, buf) : Operation.alloc(1, dirName, name, buf);
        Operation old = log.put(key, op);
        if (first && old != null && old.type == 2) {
            op.type = 1;
        }
        if (copy) {
            op.value = old != null && old.type == 1 && old.value.length == buf.length ? old.value : new byte[buf.length];
            System.arraycopy(buf, 0, op.value, 0, buf.length);
        }
        if (old != null) {
            old.free();
        }
    }

    private final byte[] getFromLog(Hashtable log, Object key) throws IOException {
        Operation op = (Operation)log.get(key);
        if (op != null) {
            if (op.type == 1 || op.type == 4) {
                return op.value;
            }
            if (op.type == 2) {
                throw new FileNotFoundException();
            }
        }
        return null;
    }

    private final byte[] getFromLog(String dirName, String name) throws IOException {
        Object key = OperationKey.newKey(dirName, name);
        byte[] buf = this.getFromLog(((AbstractTransaction.Context)this.perThreadContext.get()).getLog(), key);
        if (buf != null) {
            return buf;
        }
        buf = this.getFromLog(this.logFile.log, key);
        if (buf != null) {
            return buf;
        }
        return null;
    }

    @Override
    public byte[] loadByteArray(String dirName, String name) throws IOException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("NTransaction, loadByteArray(" + dirName + '/' + name + ")"));
        }
        try {
            byte[] buf = this.getFromLog(dirName, name);
            if (buf != null) {
                return buf;
            }
            return this.repository.load(dirName, name);
        }
        catch (FileNotFoundException exc) {
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)("NTransaction, loadByteArray(" + dirName + '/' + name + ") not found"));
            }
            return null;
        }
    }

    @Override
    public final void delete(String dirName, String name) {
        Operation op;
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("NTransaction, delete(" + dirName + ", " + name + ")"));
        }
        Object key = OperationKey.newKey(dirName, name);
        Hashtable log = ((AbstractTransaction.Context)this.perThreadContext.get()).getLog();
        Operation old = log.put(key, op = Operation.alloc(2, dirName, name));
        if (old != null) {
            if (old.type == 4) {
                op.type = 5;
            }
            old.free();
        }
    }

    @Override
    public final synchronized void commit(boolean release) throws IOException {
        Hashtable log;
        if (this.phase != 2) {
            throw new IllegalStateException("Can not commit.");
        }
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("NTransaction, commit(" + release + ')'));
        }
        if (!(log = ((AbstractTransaction.Context)this.perThreadContext.get()).getLog()).isEmpty()) {
            this.logFile.commit(log);
            log.clear();
        }
        this.setPhase(3);
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)"NTransaction, committed");
        }
        if (release) {
            this.setPhase(1);
            this.notify();
        }
    }

    @Override
    public final synchronized void garbage() {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)"NTransaction, garbages");
        }
        while (this.phase != 1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.setPhase(5);
        try {
            this.logFile.garbage();
        }
        catch (IOException exc) {
            logmon.log(BasicLevel.WARN, (Object)"NTransaction, can't garbage logfile", (Throwable)exc);
        }
        this.setPhase(1);
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)("NTransaction, garbaged: " + this.toString()));
        }
    }

    @Override
    public synchronized void stop() {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)"NTransaction, stops");
        }
        while (this.phase != 1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.setPhase(6);
        try {
            this.logFile.garbage();
        }
        catch (IOException exc) {
            logmon.log(BasicLevel.WARN, (Object)"NTransaction, can't garbage logfile", (Throwable)exc);
        }
        this.setPhase(1);
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)("NTransaction, stopped: " + this.toString()));
        }
    }

    @Override
    public synchronized void close() {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)"NTransaction, closes");
        }
        if (this.phase == 0) {
            return;
        }
        while (this.phase != 1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.setPhase(6);
        this.logFile.stop();
        this.setPhase(0);
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)("NTransaction, closed: " + this.toString()));
        }
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append('(').append(super.toString());
        strbuf.append(",LogMemorySize=").append(this.getLogMemorySize());
        strbuf.append(",LogFileSize=").append(this.getLogFileSize());
        strbuf.append(",CommitCount=").append(this.getCommitCount());
        strbuf.append(",GarbageCount=").append(this.getGarbageCount());
        strbuf.append(",GarbageRatio=").append(this.getGarbageRatio());
        strbuf.append(",NbSavedObjects=").append(this.getNbSavedObjects());
        strbuf.append(",NbDeletedObjects=").append(this.getNbDeletedObjects());
        strbuf.append(",NbBadDeletedObjects=").append(this.getNbBadDeletedObjects());
        strbuf.append(",NbLoadedObjects=").append(this.getNbLoadedObjects());
        strbuf.append(')');
        return strbuf.toString();
    }

    public static void main(String[] args) throws Exception {
        if ("garbage".equals(args[0])) {
            NTransaction transaction = new NTransaction();
            transaction.init(args[1]);
            transaction.stop();
        } else if (!"list".equals(args[0])) {
            System.err.println("unknown command: " + args[0]);
        }
    }

    @Override
    public String backup(String path) throws Exception {
        throw new UnsupportedOperationException("Backup operation not already implemented.");
    }

    static final class LogFile
    extends ByteArrayOutputStream {
        Hashtable<Object, Operation> log = null;
        RandomAccessFile logFile = null;
        int current = -1;
        int commitCount = 0;
        int garbageCount = 0;
        long garbageTime = 0L;
        long lastGarbageTime = 0L;
        long garbageTimeOut = 0L;
        private static final String LockPathname = "lock";
        private Repository repository = null;
        private String mode;
        private static final byte[] emptyUTFString = new byte[]{0, 0};
        int logMemorySize = 0;

        int getLogFileSize() {
            return this.current;
        }

        LogFile(File dir, Repository repository, boolean syncOnWrite) throws IOException {
            super(4096);
            this.repository = repository;
            this.mode = syncOnWrite ? "rwd" : "rw";
            this.log = new Hashtable(LogMemoryCapacity);
            File logFilePN = new File(dir, "log");
            if (logFilePN.exists() && logFilePN.length() > 0L) {
                this.logFile = new RandomAccessFile(logFilePN, "r");
                try {
                    int optype = this.logFile.read();
                    while (optype == 3) {
                        optype = this.logFile.read();
                        while (optype == 4 || optype == 1 || optype == 2) {
                            String dirName = this.logFile.readUTF();
                            if (dirName.length() == 0) {
                                dirName = null;
                            }
                            String name = this.logFile.readUTF();
                            Object key = OperationKey.newKey(dirName, name);
                            if (BaseTransaction.logmon.isLoggable(BasicLevel.DEBUG)) {
                                BaseTransaction.logmon.log(BasicLevel.DEBUG, (Object)("NTransaction.init(), OPERATION=" + optype + ", " + name));
                            }
                            Operation op = null;
                            if (optype == 1 || optype == 4) {
                                byte[] buf = new byte[this.logFile.readInt()];
                                this.logFile.readFully(buf);
                                op = Operation.alloc(optype, dirName, name, buf);
                                Operation old = this.log.put(key, op);
                                if (old != null) {
                                    old.free();
                                }
                            } else {
                                op = Operation.alloc(optype, dirName, name);
                                Operation old = this.log.put(key, op);
                                if (old != null) {
                                    if (old.type == 4) {
                                        op.type = 5;
                                    }
                                    old.free();
                                }
                            }
                            optype = this.logFile.read();
                        }
                        if (!BaseTransaction.logmon.isLoggable(BasicLevel.DEBUG)) continue;
                        BaseTransaction.logmon.log(BasicLevel.DEBUG, (Object)("NTransaction.init(), COMMIT=" + optype));
                    }
                    if (BaseTransaction.logmon.isLoggable(BasicLevel.DEBUG)) {
                        BaseTransaction.logmon.log(BasicLevel.DEBUG, (Object)("NTransaction.init(), END=" + optype + ", " + this.logFile.getFilePointer()));
                    }
                    if (optype != 127) {
                        throw new IOException("Corrupted transaction log");
                    }
                }
                catch (IOException exc) {
                    throw exc;
                }
                finally {
                    this.logFile.close();
                }
                this.logFile = new RandomAccessFile(logFilePN, this.mode);
                this.garbage();
            } else {
                this.logFile = new RandomAccessFile(logFilePN, this.mode);
                this.logFile.setLength(MaxLogFileSize);
                this.current = 1;
                this.logFile.seek(0L);
                this.logFile.write(127);
            }
        }

        void writeUTF(String str) {
            int strlen = str.length();
            int newcount = this.count + strlen + 2;
            if (newcount > this.buf.length) {
                byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
                System.arraycopy(this.buf, 0, newbuf, 0, this.count);
                this.buf = newbuf;
            }
            this.buf[this.count++] = (byte)(strlen >>> 8 & 0xFF);
            this.buf[this.count++] = (byte)(strlen >>> 0 & 0xFF);
            str.getBytes(0, strlen, this.buf, this.count);
            this.count = newcount;
        }

        void writeInt(int v) {
            int newcount = this.count + 4;
            if (newcount > this.buf.length) {
                byte[] newbuf = new byte[this.buf.length << 1];
                System.arraycopy(this.buf, 0, newbuf, 0, this.count);
                this.buf = newbuf;
            }
            this.buf[this.count++] = (byte)(v >>> 24 & 0xFF);
            this.buf[this.count++] = (byte)(v >>> 16 & 0xFF);
            this.buf[this.count++] = (byte)(v >>> 8 & 0xFF);
            this.buf[this.count++] = (byte)(v >>> 0 & 0xFF);
        }

        void commit(Hashtable<Object, Operation> ctxlog) throws IOException {
            if (BaseTransaction.logmon.isLoggable(BasicLevel.DEBUG)) {
                BaseTransaction.logmon.log(BasicLevel.DEBUG, (Object)"NTransaction.LogFile.commit()");
            }
            ++this.commitCount;
            Operation op = null;
            Enumeration<Operation> e = ctxlog.elements();
            while (e.hasMoreElements()) {
                Operation old;
                op = e.nextElement();
                if (op.type == 5) continue;
                this.write(op.type);
                if (op.dirName != null) {
                    this.writeUTF(op.dirName);
                } else {
                    this.write(emptyUTFString);
                }
                this.writeUTF(op.name);
                if (op.type == 1 || op.type == 4) {
                    this.logMemorySize += op.value.length;
                    this.writeInt(op.value.length);
                    this.write(op.value);
                }
                if ((old = this.log.put(OperationKey.newKey(op.dirName, op.name), op)) == null) continue;
                if (old.type == 1 || old.type == 4) {
                    this.logMemorySize -= old.value.length;
                }
                if (old.type == 4) {
                    if (op.type == 2) {
                        op.type = 5;
                    } else if (op.type == 1) {
                        op.type = 4;
                    }
                }
                old.free();
            }
            this.write(127);
            this.logFile.seek(this.current);
            this.logFile.write(this.buf, 0, this.count);
            this.logFile.seek(this.current - 1);
            this.logFile.write(3);
            this.current += this.count;
            this.reset();
            ctxlog.clear();
            if (this.current > MaxLogFileSize || this.logMemorySize > MaxLogMemorySize || this.garbageTimeOut > 0L && System.currentTimeMillis() > this.lastGarbageTime + this.garbageTimeOut) {
                this.garbage();
            }
        }

        private final void garbage() throws IOException {
            long end;
            long start = System.currentTimeMillis();
            if (BaseTransaction.logmon.isLoggable(BasicLevel.DEBUG)) {
                BaseTransaction.logmon.log(BasicLevel.DEBUG, (Object)"NTransaction.LogFile.garbage() - begin");
            }
            ++this.garbageCount;
            Operation op = null;
            Enumeration<Operation> e = this.log.elements();
            while (e.hasMoreElements()) {
                op = e.nextElement();
                if (op.type == 1 || op.type == 4) {
                    if (BaseTransaction.logmon.isLoggable(BasicLevel.DEBUG)) {
                        BaseTransaction.logmon.log(BasicLevel.DEBUG, (Object)("NTransaction, LogFile.Save (" + op.dirName + '/' + op.name + ')'));
                    }
                    this.repository.save(op.dirName, op.name, op.value);
                } else if (op.type == 2) {
                    if (BaseTransaction.logmon.isLoggable(BasicLevel.DEBUG)) {
                        BaseTransaction.logmon.log(BasicLevel.DEBUG, (Object)("NTransaction, LogFile.Delete (" + op.dirName + '/' + op.name + ')'));
                    }
                    this.repository.delete(op.dirName, op.name);
                }
                op.free();
            }
            this.log.clear();
            this.logMemorySize = 0;
            this.repository.commit();
            this.current = 1;
            this.logFile.seek(0L);
            this.logFile.write(127);
            this.lastGarbageTime = end = System.currentTimeMillis();
            this.garbageTime += end - start;
            if (BaseTransaction.logmon.isLoggable(BasicLevel.DEBUG)) {
                BaseTransaction.logmon.log(BasicLevel.DEBUG, (Object)("NTransaction.LogFile.garbage() - end: " + (end - start)));
            }
        }

        void stop() {
            if (BaseTransaction.logmon.isLoggable(BasicLevel.DEBUG)) {
                BaseTransaction.logmon.log(BasicLevel.DEBUG, (Object)"NTransaction.LogFile, stops");
            }
            try {
                this.garbage();
                this.logFile.close();
                this.repository.close();
            }
            catch (IOException exc) {
                BaseTransaction.logmon.log(BasicLevel.WARN, (Object)"NTransaction.LogFile, can't close logfile", (Throwable)exc);
            }
            if (BaseTransaction.logmon.isLoggable(BasicLevel.DEBUG)) {
                BaseTransaction.logmon.log(BasicLevel.DEBUG, (Object)"NTransaction.LogFile, stopped.");
            }
        }
    }

    private class GarbageTask
    extends TimerTask {
        private GarbageTask() {
            if (NTransaction.this.timer == null) {
                NTransaction.this.timer = new Timer("NTransaction.Timer");
            }
            if (NTransaction.this.logFile.garbageTimeOut > 0L) {
                try {
                    NTransaction.this.timer.schedule((TimerTask)this, NTransaction.this.logFile.garbageTimeOut, NTransaction.this.logFile.garbageTimeOut);
                }
                catch (Exception exc) {
                    BaseTransaction.logmon.log(BasicLevel.ERROR, (Object)"NTransaction, cannot schedule garbage task ", (Throwable)exc);
                }
            }
        }

        @Override
        public void run() {
            if (NTransaction.this.logFile.garbageTimeOut > 0L && System.currentTimeMillis() > NTransaction.this.logFile.lastGarbageTime + NTransaction.this.logFile.garbageTimeOut) {
                NTransaction.this.garbage();
            }
        }
    }
}

