/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.util;

import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.common.BinaryDump;
import fr.dyade.aaa.util.AbstractTransaction;
import fr.dyade.aaa.util.DBOperation;
import fr.dyade.aaa.util.DBTransactionMBean;
import fr.dyade.aaa.util.backup.BackupFile;
import fr.dyade.aaa.util.backup.BackupRecord;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.objectweb.util.monolog.api.BasicLevel;

public abstract class DBTransaction
extends AbstractTransaction
implements DBTransactionMBean {
    public static final String DB_TRANSACTION_PREFIX = "org.ow2.joram.dbtransaction";
    public static final String TABLE_NAME_PROP = "org.ow2.joram.dbtransaction.dbtable";
    public static final String DFLT_TABLE_PREFIX = "JoramDB";
    protected String dbtable;
    static int LogThresholdOperation = 1000;
    protected Connection conn = null;
    protected String dbinsert = null;
    protected String dbupdate = null;
    protected String dbload = null;
    protected String dbdelete = null;
    protected String dbclose = null;
    private PreparedStatement insertStmt = null;
    private PreparedStatement updateStmt = null;
    private PreparedStatement loadStmt = null;
    private PreparedStatement deleteStmt = null;
    private int commitCount = 0;
    private long commitBytes = 0L;
    protected final int JDBC_CONNECT_RETRY_COUNT_DFLT = 5;
    protected int connectRetryCount = 5;
    protected final long JDBC_CONNECT_RETRY_MAX_PERIOD_DFLT = 60000L;
    protected long connectRetryMaxPeriod = 60000L;
    protected final long JDBC_CONNECT_RETRY_MIN_DELAY_DFLT = 1000L;
    protected long connectRetryMinDelay = 1000L;
    int nbinserts = 0;
    int badinserts = 0;
    int nbupdates = 0;
    int badupdates = 0;
    int nbdeletes = 0;
    int nbnoop;

    @Override
    public String getDBTableName() {
        return this.dbtable;
    }

    @Override
    public int getLogThresholdOperation() {
        return LogThresholdOperation;
    }

    @Override
    public String getDBInsertStatement() {
        return this.dbinsert;
    }

    @Override
    public String getDBUpdateStatement() {
        return this.dbupdate;
    }

    @Override
    public String getDBLoadStatement() {
        return this.dbload;
    }

    @Override
    public String getDBDeleteStatement() {
        return this.dbdelete;
    }

    @Override
    public String getDBCloseStatement() {
        return this.dbclose;
    }

    @Override
    public void initRepository() throws IOException {
        this.dbtable = AgentServer.getProperty(TABLE_NAME_PROP, DFLT_TABLE_PREFIX + AgentServer.getServerId());
        this.initDB();
        this.createPreparedStatement();
    }

    private void createPreparedStatement() throws IOException {
        try {
            this.insertStmt = this.dbinsert == null ? this.conn.prepareStatement("INSERT INTO " + this.dbtable + " VALUES (?, ?)") : this.conn.prepareStatement(this.dbinsert);
            this.updateStmt = this.dbupdate == null ? this.conn.prepareStatement("UPDATE " + this.dbtable + " SET content=? WHERE name=?") : this.conn.prepareStatement(this.dbupdate);
            this.loadStmt = this.dbload == null ? this.conn.prepareStatement("SELECT content FROM " + this.dbtable + " WHERE name=?") : this.conn.prepareStatement(this.dbload);
            this.deleteStmt = this.dbdelete == null ? this.conn.prepareStatement("DELETE FROM " + this.dbtable + " WHERE name=?") : this.conn.prepareStatement(this.dbdelete);
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw new IOException(sqle.getMessage());
        }
    }

    protected abstract void initDB() throws IOException;

    public String getPersistenceDir() {
        return this.dir.getPath();
    }

    @Override
    protected final void setPhase(int newPhase) {
        this.phase = newPhase;
    }

    @Override
    public final int getCommitCount() {
        return this.commitCount;
    }

    @Override
    public final long getCommitBytes() {
        return this.commitBytes;
    }

    @Override
    public String getObjectList(String prefix) {
        String[] list = this.getList(prefix);
        if (list != null) {
            StringBuilder strbuf = new StringBuilder();
            for (String name : list) {
                strbuf.append(name).append(", ");
            }
            return strbuf.toString();
        }
        return null;
    }

    @Override
    public final synchronized String[] getList(String prefix) {
        try {
            Statement s = this.conn.createStatement();
            ResultSet rs = s.executeQuery("SELECT name FROM " + this.dbtable + " WHERE name LIKE '" + prefix + "%'");
            Vector<String> v = new Vector<String>();
            while (rs.next()) {
                v.add(rs.getString(1));
            }
            rs.close();
            s.close();
            String[] result = new String[v.size()];
            result = v.toArray(result);
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)("DBTransaction, getList: " + v));
            }
            return result;
        }
        catch (SQLException sqle) {
            logmon.log(BasicLevel.DEBUG, (Object)"DBTransaction.getList()", (Throwable)sqle);
            return null;
        }
    }

    public byte[] getFromLog(String name) throws IOException {
        Hashtable log;
        DBOperation op;
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("DBTransaction, getFromLog(" + name + ")"));
        }
        if ((op = (DBOperation)(log = ((AbstractTransaction.Context)this.perThreadContext.get()).getLog()).get(name)) != null && (op.type == 1 || op.type == 4)) {
            return op.value;
        }
        return null;
    }

    @Override
    public boolean useLoadAll() {
        return true;
    }

    @Override
    public void loadAll(String prefix, Map map) {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("DBTransaction, loadAll(" + prefix + ")"));
        }
        try {
            Statement s = this.conn.createStatement();
            ResultSet rs = s.executeQuery("SELECT name, content FROM " + this.dbtable + " WHERE  ((name LIKE '" + prefix + "%') AND (name NOT LIKE '%B'))");
            while (rs.next()) {
                String name = rs.getString(1);
                byte[] content = null;
                try {
                    content = this.getFromLog(name);
                }
                catch (IOException exc) {
                    if (logmon.isLoggable(BasicLevel.DEBUG)) {
                        logmon.log(BasicLevel.WARN, (Object)("DBTransaction, loadAll: cannot retrieve content for " + name), (Throwable)exc);
                    }
                    logmon.log(BasicLevel.WARN, (Object)("DBTransaction, loadAll: cannot retrieve content for " + name + " - " + exc.getMessage()));
                }
                if (content == null) {
                    content = rs.getBytes(2);
                }
                if (content == null) {
                    logmon.log(BasicLevel.WARN, (Object)("DBTransaction, loadAll: no content for " + name));
                    continue;
                }
                try {
                    map.put(name, this.loadFromByteArray(content));
                }
                catch (IOException | ClassNotFoundException exc) {
                    if (logmon.isLoggable(BasicLevel.DEBUG)) {
                        logmon.log(BasicLevel.WARN, (Object)("DBTransaction, loadAll: cannot retrieve content for " + name), (Throwable)exc);
                        continue;
                    }
                    logmon.log(BasicLevel.WARN, (Object)("DBTransaction, loadAll: cannot retrieve content for " + name + " - " + exc.getMessage()));
                }
            }
            rs.close();
            s.close();
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)("DBTransaction, loadAll: " + map.size()));
            }
            return;
        }
        catch (SQLException sqle) {
            logmon.log(BasicLevel.DEBUG, (Object)"DBTransaction.getList()", (Throwable)sqle);
            return;
        }
    }

    final String fname(String dirName, String name) {
        if (dirName == null) {
            return name;
        }
        return new StringBuffer(dirName).append('/').append(name).toString();
    }

    @Override
    protected final void saveInLog(byte[] buf, String dirName, String name, Hashtable log, boolean copy, boolean first) throws IOException {
        String fname = this.fname(dirName, name);
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("DBTransaction, saveInLog(" + fname + ", " + copy + ", " + first + ")"));
        }
        DBOperation op = DBOperation.alloc(1, fname, buf);
        op = first ? DBOperation.alloc(4, fname, buf) : DBOperation.alloc(1, fname, buf);
        DBOperation old = log.put(fname, op);
        if (first && old != null && old.type == 2) {
            op.type = 1;
        }
        if (copy) {
            op.value = old != null && old.type == 1 && old.value.length == buf.length ? old.value : new byte[buf.length];
            System.arraycopy(buf, 0, op.value, 0, buf.length);
        }
        if (old != null) {
            old.free();
        }
    }

    @Override
    public String getObject(String dirname, String name) {
        try {
            byte[] bytes = this.loadByteArray(dirname, name);
            if (bytes != null) {
                return BinaryDump.toHex(bytes);
            }
            return "null";
        }
        catch (IOException exc) {
            return exc.getMessage();
        }
    }

    @Override
    public byte[] loadByteArray(String dirName, String name) throws IOException {
        Hashtable log;
        DBOperation op;
        String fname = this.fname(dirName, name);
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("DBTransaction, loadByteArray(" + fname + ")"));
        }
        if ((op = (DBOperation)(log = ((AbstractTransaction.Context)this.perThreadContext.get()).getLog()).get(fname)) != null) {
            if (op.type == 1 || op.type == 4) {
                return op.value;
            }
            if (op.type == 2) {
                return null;
            }
        }
        try {
            this.loadStmt.setString(1, fname);
            ResultSet rs = this.loadStmt.executeQuery();
            if (!rs.next()) {
                return null;
            }
            byte[] content = rs.getBytes(1);
            rs.close();
            return content;
        }
        catch (SQLException sqle) {
            throw new IOException(sqle.getMessage());
        }
    }

    @Override
    public void delete(String dirName, String name) {
        DBOperation op;
        Hashtable log;
        DBOperation old;
        String fname = this.fname(dirName, name);
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("DBTransaction, delete(" + fname + ")"));
        }
        if ((old = (log = ((AbstractTransaction.Context)this.perThreadContext.get()).getLog()).put(fname, op = DBOperation.alloc(2, fname))) != null) {
            if (old.type == 4) {
                op.type = 5;
            }
            old.free();
        }
    }

    protected abstract void connectDB() throws IOException;

    @Override
    public final synchronized void commit(boolean release) throws IOException {
        Hashtable log;
        if (this.phase != 2) {
            throw new IllegalStateException("Can not commit.");
        }
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)"DBTransaction, commit");
        }
        if (!(log = ((AbstractTransaction.Context)this.perThreadContext.get()).getLog()).isEmpty()) {
            boolean completed = false;
            int retry = 0;
            long startRetry = 0L;
            long lastTry = 0L;
            SQLException lastexc = null;
            do {
                try {
                    this.dbLogCommit(log);
                    lastexc = null;
                    completed = true;
                }
                catch (SQLException sqle) {
                    lastexc = sqle;
                    ++retry;
                    long time = System.currentTimeMillis();
                    if (startRetry == 0L) {
                        startRetry = time;
                    }
                    if (this.connectRetryCount > 0 && retry > this.connectRetryCount) {
                        logmon.log(BasicLevel.WARN, (Object)("DBTransaction, commit: maximum number of reconnection attempts reached: " + this.connectRetryCount));
                        break;
                    }
                    if (this.connectRetryMaxPeriod > 0L && time - startRetry > this.connectRetryMaxPeriod) {
                        logmon.log(BasicLevel.WARN, (Object)("DBTransaction, commit: reconnection period exceeded: " + this.connectRetryMaxPeriod));
                        break;
                    }
                    try {
                        if (lastTry != 0L) {
                            long delay = this.connectRetryMinDelay - (time - lastTry);
                            try {
                                if (delay > 0L) {
                                    Thread.sleep(delay);
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        if (logmon.isLoggable(BasicLevel.DEBUG)) {
                            logmon.log(BasicLevel.WARN, (Object)"DBTransaction, commit: try to reconnect", (Throwable)sqle);
                        } else {
                            logmon.log(BasicLevel.WARN, (Object)("DBTransaction, commit: try to reconnect - " + sqle.getMessage()));
                        }
                        lastTry = System.currentTimeMillis();
                        this.connectDB();
                        this.createPreparedStatement();
                        logmon.log(BasicLevel.DEBUG, (Object)"DBTransaction, commit: DB connected");
                    }
                    catch (IOException exc) {
                        logmon.log(BasicLevel.INFO, (Object)("DBTransaction, commit: cannot reconnect" + exc.getMessage()));
                    }
                }
            } while (!completed);
            if (lastexc != null) {
                throw new IOException(lastexc.getMessage());
            }
            if (startRetry != 0L) {
                logmon.log(BasicLevel.WARN, (Object)"DBTransaction, commit: reconnected");
            }
            log.forEach((k, op) -> op.free());
            log.clear();
        }
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)"DBTransaction, committed");
        }
        if (release) {
            this.setPhase(1);
            this.notify();
        } else {
            this.setPhase(3);
        }
    }

    private void dbLogCommit(Hashtable<String, DBOperation> log) throws SQLException {
        try {
            this.dbLogExecute(log);
        }
        catch (SQLException sqle) {
            this.conn.rollback();
            throw sqle;
        }
        this.conn.commit();
        ++this.commitCount;
    }

    @Override
    public final int getNbInserts() {
        return this.nbinserts;
    }

    @Override
    public final int getBadInserts() {
        return this.badinserts;
    }

    @Override
    public final int getNbUpdates() {
        return this.nbupdates;
    }

    @Override
    public int getBadUpdates() {
        return this.badupdates;
    }

    @Override
    public final int getNbDeletes() {
        return this.nbdeletes;
    }

    private void dbLogExecute(Hashtable<String, DBOperation> log) throws SQLException {
        DBOperation op = null;
        Enumeration<DBOperation> e = log.elements();
        while (e.hasMoreElements()) {
            op = e.nextElement();
            if (op.type == 4) {
                this.commitBytes += (long)op.value.length;
                if (logmon.isLoggable(BasicLevel.DEBUG)) {
                    logmon.log(BasicLevel.DEBUG, (Object)("DBTransaction, dbLogCommit.create(" + op.name + ", " + op.value.length + ") -> " + this.commitBytes));
                }
                try {
                    ++this.nbinserts;
                    this.insertStmt.setString(1, op.name);
                    this.insertStmt.setBytes(2, op.value);
                    this.insertStmt.executeUpdate();
                    continue;
                }
                catch (SQLException sqle1) {
                    if (!(sqle1 instanceof SQLIntegrityConstraintViolationException)) {
                        logmon.log(BasicLevel.WARN, (Object)("DBTransaction, dbLogCommit.create(" + op.name + ") -> "), (Throwable)sqle1);
                    }
                    ++this.badinserts;
                    logmon.log(BasicLevel.INFO, (Object)("DBTransaction, dbLogCommit.create(" + op.name + ") -> needs update"));
                    ++this.nbupdates;
                    this.updateStmt.setBytes(1, op.value);
                    this.updateStmt.setString(2, op.name);
                    this.updateStmt.executeUpdate();
                    continue;
                }
            }
            if (op.type == 1) {
                this.commitBytes += (long)op.value.length;
                if (logmon.isLoggable(BasicLevel.DEBUG)) {
                    logmon.log(BasicLevel.DEBUG, (Object)("DBTransaction, dbLogCommit.save(" + op.name + ", " + op.value.length + ") -> " + this.commitBytes));
                }
                int rows = -1;
                ++this.nbupdates;
                this.updateStmt.setBytes(1, op.value);
                this.updateStmt.setString(2, op.name);
                rows = this.updateStmt.executeUpdate();
                if (rows == 1) continue;
                ++this.nbinserts;
                logmon.log(BasicLevel.INFO, (Object)("DBTransaction, dbLogCommit.save(" + op.name + ") needs insert -> " + rows));
                ++this.badupdates;
                try {
                    this.insertStmt.setString(1, op.name);
                    this.insertStmt.setBytes(2, op.value);
                    this.insertStmt.executeUpdate();
                }
                catch (SQLException sqle1) {
                    if (sqle1 instanceof SQLIntegrityConstraintViolationException) continue;
                    logmon.log(BasicLevel.WARN, (Object)("DBTransaction, dbLogCommit.save(" + op.name + ") -> "), (Throwable)sqle1);
                }
                continue;
            }
            if (op.type == 2) {
                if (logmon.isLoggable(BasicLevel.DEBUG)) {
                    logmon.log(BasicLevel.DEBUG, (Object)("DBTransaction, dbLogCommit.delete(" + op.name + ')'));
                }
                ++this.nbdeletes;
                this.deleteStmt.setString(1, op.name);
                this.deleteStmt.executeUpdate();
                continue;
            }
            if (op.type != 5) continue;
            ++this.nbnoop;
            logmon.log(BasicLevel.DEBUG, (Object)("DBTransaction, dbLogCommit.noop(" + op.name + ')'));
        }
    }

    @Override
    public synchronized void stop() {
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)"DBTransaction, stops");
        }
        while (this.phase != 1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.setPhase(6);
        Statement s = null;
        try {
            if (this.dbclose != null && this.dbclose.length() > 0) {
                s = this.conn.createStatement();
                s.executeUpdate(this.dbclose);
            }
        }
        catch (SQLException sqle) {
            logmon.log(BasicLevel.ERROR, (Object)"DBTransaction.stop()", (Throwable)sqle);
        }
        catch (Throwable t) {
            logmon.log(BasicLevel.ERROR, (Object)"DBTransaction.stop()", t);
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (SQLException sqle) {
                logmon.log(BasicLevel.ERROR, (Object)"DBTransaction.stop()", (Throwable)sqle);
            }
            logmon.log(BasicLevel.INFO, (Object)"DBTransaction.stop(), stopped");
        }
        this.setPhase(1);
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)("DBTransaction, stopped: " + this.commitCount + '(' + this.commitBytes + "), " + this.nbinserts + '(' + this.badinserts + "), " + this.nbupdates + '(' + this.badupdates + "), " + this.nbdeletes + '(' + this.nbnoop + ')'));
        }
    }

    @Override
    public synchronized void close() {
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)"DBTransaction, close");
        }
        if (this.phase == 0) {
            return;
        }
        while (this.phase != 1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.setPhase(6);
        Statement s = null;
        try {
            this.insertStmt.close();
            this.updateStmt.close();
            this.loadStmt.close();
            this.deleteStmt.close();
            if (this.dbclose != null && this.dbclose.length() > 0) {
                s = this.conn.createStatement();
                s.executeUpdate(this.dbclose);
            }
            this.conn.commit();
        }
        catch (SQLException sqle) {
            logmon.log(BasicLevel.ERROR, (Object)"DBTransaction.close()", (Throwable)sqle);
        }
        catch (Throwable t) {
            logmon.log(BasicLevel.ERROR, (Object)"DBTransaction.close()", t);
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (SQLException sqle) {
                logmon.log(BasicLevel.ERROR, (Object)"DBTransaction.stop()", (Throwable)sqle);
            }
            try {
                this.conn.close();
            }
            catch (SQLException sqle) {
                logmon.log(BasicLevel.ERROR, (Object)"DBTransaction.close(), closing driver", (Throwable)sqle);
            }
            logmon.log(BasicLevel.INFO, (Object)"DBTransaction.close(), stopped");
        }
        this.setPhase(0);
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)"DBTransaction, closed");
        }
    }

    @Override
    public String dumpProperties() {
        StringBuilder strbuf = new StringBuilder();
        strbuf.append('[');
        this.dumpProperties(strbuf);
        strbuf.append(']');
        return strbuf.toString();
    }

    protected void dumpProperties(StringBuilder strbuf) {
        strbuf.append('(').append("dbtable=").append(this.dbtable);
    }

    @Override
    public synchronized String backup(String path) throws Exception {
        logmon.log(BasicLevel.DEBUG, (Object)"DBTransaction, backup");
        if (path == null || path.isEmpty()) {
            path = ".";
        }
        try {
            long start = System.currentTimeMillis();
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd-HHmmss");
            String backupName = "backup-" + format.format(new Date());
            File backupTempFile = new File(path, backupName + ".temp");
            BackupFile backupFile = new BackupFile(backupTempFile);
            logmon.log(BasicLevel.INFO, (Object)("DBTransaction, backup: " + path));
            Statement s = this.conn.createStatement();
            ResultSet rs = s.executeQuery("SELECT name, content FROM " + this.dbtable);
            while (rs.next()) {
                String name = rs.getString(1);
                byte[] content = rs.getBytes(2);
                int idx = name.lastIndexOf(47);
                String dirName = null;
                if (idx != -1) {
                    dirName = name.substring(0, idx);
                    name = name.substring(idx + 1);
                }
                backupFile.backup(new BackupRecord(dirName, name, content));
            }
            backupFile.close();
            rs.close();
            s.close();
            File resultFile = new File(path, backupName + ".tbck");
            backupTempFile.renameTo(resultFile);
            long end = System.currentTimeMillis();
            logmon.log(BasicLevel.INFO, (Object)("DBTransaction, backup end: " + (end - start)));
            return resultFile.getName();
        }
        catch (Exception exc) {
            logmon.log(BasicLevel.ERROR, (Object)"DBTransaction, backup error", (Throwable)exc);
            throw exc;
        }
    }
}

