/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.common.encoding;

import fr.dyade.aaa.common.encoding.Decoder;
import fr.dyade.aaa.common.encoding.Encoder;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class EncodableHelper {
    public static final int getStringEncodedSize(String s) {
        return 4 + s.length();
    }

    public static final int getNullableStringEncodedSize(String s) {
        int res = 1;
        if (s != null) {
            res += 4 + s.length();
        }
        return res;
    }

    public static final int getByteArrayEncodedSize(byte[] byteArray) {
        return 4 + byteArray.length;
    }

    public static final int getNullableByteArrayEncodedSize(byte[] byteArray) {
        int res = 1;
        if (byteArray != null) {
            res += 4 + byteArray.length;
        }
        return res;
    }

    public static final int getNullableByteArrayEncodedSize(byte[] byteArray, int length) {
        int res = 1;
        if (byteArray != null) {
            res += 4 + length;
        }
        return res;
    }

    public static int getEncodedSize(Properties properties) throws Exception {
        int res = 4;
        Set<Map.Entry<Object, Object>> entries = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            res += EncodableHelper.getStringEncodedSize((String)entry.getKey());
            res += EncodableHelper.getStringEncodedSize((String)entry.getValue());
        }
        return res;
    }

    public static void encodeProperties(Properties properties, Encoder encoder) throws Exception {
        encoder.encodeUnsignedInt(properties.size());
        Set<Map.Entry<Object, Object>> entries = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            encoder.encodeString((String)entry.getKey());
            encoder.encodeString((String)entry.getValue());
        }
    }

    public static Properties decodeProperties(Decoder decoder) throws Exception {
        Properties properties = new Properties();
        int size = decoder.decodeUnsignedInt();
        for (int i = 0; i < size; ++i) {
            String key = decoder.decodeString();
            String value = decoder.decodeString();
            properties.put(key, value);
        }
        return properties;
    }
}

