/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.Debug;
import fr.dyade.aaa.agent.ServiceDesc;
import fr.dyade.aaa.common.Strings;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Set;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class ServiceManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    static ServiceManager manager;
    static Logger xlogmon;
    private static String name;
    public static String txname;
    Hashtable<String, ServiceDesc> registry = new Hashtable();

    public static final String getName() {
        if (name == null) {
            name = AgentServer.getName() + ".ServiceManager";
        }
        return name;
    }

    static void init() throws Exception {
        xlogmon = Debug.getLogger("fr.dyade.aaa.agent.Service");
        manager = ServiceManager.load();
        if (manager == null) {
            manager = new ServiceManager();
        }
        ServiceManager.save();
    }

    static ServiceManager load() throws IOException, ClassNotFoundException {
        return (ServiceManager)AgentServer.getTransaction().load(txname);
    }

    static void save() throws IOException {
        AgentServer.getTransaction().save(manager, txname);
        AgentServer.getTransaction().begin();
        AgentServer.getTransaction().commit(true);
        if (xlogmon.isLoggable(BasicLevel.DEBUG)) {
            xlogmon.log(BasicLevel.DEBUG, (Object)(ServiceManager.getName() + " service manager saved."));
        }
    }

    private ServiceManager() {
    }

    public static void loadServiceClasses() throws Exception {
        Enumeration<ServiceDesc> e = ServiceManager.manager.registry.elements();
        while (e.hasMoreElements()) {
            ServiceDesc desc = e.nextElement();
            try {
                ServiceManager.loadServiceClass(desc);
            }
            catch (Exception exc) {
                if (xlogmon.isLoggable(BasicLevel.DEBUG)) {
                    xlogmon.log(BasicLevel.ERROR, (Object)(ServiceManager.getName() + ", cannot load service " + desc.getClassName()), (Throwable)exc);
                    continue;
                }
                xlogmon.log(BasicLevel.ERROR, (Object)(ServiceManager.getName() + ", cannot load service " + desc.getClassName() + ": " + exc.getMessage()));
            }
        }
    }

    public static void loadServiceClass(ServiceDesc desc) throws Exception {
        Class.forName(desc.getClassName());
    }

    public static void start(ServiceDesc desc) throws Exception {
        if (xlogmon.isLoggable(BasicLevel.DEBUG)) {
            xlogmon.log(BasicLevel.DEBUG, (Object)(ServiceManager.getName() + " start service: " + desc));
        }
        if (desc.running) {
            throw new Exception("Service already running");
        }
        Class[] ptypes = new Class[]{String.class, Boolean.TYPE};
        Object[] args = new Object[]{desc.getArguments(), new Boolean(!desc.isInitialized())};
        Class<?> service = null;
        service = Class.forName(desc.getClassName());
        Method init = service.getMethod("init", ptypes);
        init.invoke(null, args);
        desc.running = true;
        desc.initialized = true;
        if (xlogmon.isLoggable(BasicLevel.DEBUG)) {
            xlogmon.log(BasicLevel.DEBUG, (Object)(ServiceManager.getName() + " service started"));
        }
        ServiceManager.save();
    }

    static void start(String scname) throws Exception {
        ServiceDesc desc = ServiceManager.manager.registry.get(scname);
        if (desc == null) {
            throw new NoSuchElementException("Unknown service: " + scname);
        }
        ServiceManager.start(desc);
    }

    static void start(boolean exitOnFailure) throws Exception {
        Enumeration<ServiceDesc> e = ServiceManager.manager.registry.elements();
        while (e.hasMoreElements()) {
            ServiceDesc desc = e.nextElement();
            try {
                ServiceManager.start(desc);
            }
            catch (Exception exc) {
                if (xlogmon.isLoggable(BasicLevel.DEBUG)) {
                    xlogmon.log(BasicLevel.ERROR, (Object)(ServiceManager.getName() + ", cannot start service:" + desc.getClassName()), (Throwable)exc);
                } else {
                    xlogmon.log(BasicLevel.ERROR, (Object)(ServiceManager.getName() + ", cannot start service " + desc.getClassName() + ": " + exc.getMessage()));
                }
                if (!exitOnFailure) continue;
                throw new Exception("Cannot start service " + desc.getClassName());
            }
        }
    }

    public static void stop(ServiceDesc desc) throws Exception {
        if (!desc.running) {
            return;
        }
        Class<?> service = Class.forName(desc.getClassName());
        Method stop = service.getMethod("stopService", new Class[0]);
        stop.invoke(null, (Object[])null);
        desc.running = false;
        if (xlogmon.isLoggable(BasicLevel.DEBUG)) {
            xlogmon.log(BasicLevel.DEBUG, (Object)("Service " + desc.scname + " stopped."));
        }
    }

    public static void stop(String scname) throws Exception {
        ServiceDesc desc = ServiceManager.manager.registry.get(scname);
        if (desc == null) {
            throw new NoSuchElementException("Unknown service: " + scname);
        }
        ServiceManager.stop(desc);
    }

    static void stop() {
        if (manager == null || ServiceManager.manager.registry == null) {
            return;
        }
        Enumeration<ServiceDesc> e = ServiceManager.manager.registry.elements();
        while (e.hasMoreElements()) {
            ServiceDesc desc = e.nextElement();
            try {
                if (xlogmon.isLoggable(BasicLevel.DEBUG)) {
                    xlogmon.log(BasicLevel.DEBUG, (Object)(ServiceManager.getName() + ", stops: " + desc));
                }
                if (desc.running) {
                    ServiceManager.stop(desc);
                }
                if (!xlogmon.isLoggable(BasicLevel.DEBUG)) continue;
                xlogmon.log(BasicLevel.DEBUG, (Object)(ServiceManager.getName() + ", service stopped"));
            }
            catch (Throwable exc) {
                if (xlogmon.isLoggable(BasicLevel.DEBUG)) {
                    xlogmon.log(BasicLevel.WARN, (Object)(ServiceManager.getName() + ", cannot stop service " + desc.getClassName()), exc);
                    continue;
                }
                xlogmon.log(BasicLevel.WARN, (Object)(ServiceManager.getName() + ", cannot stop service " + desc.getClassName() + ": " + exc.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(String scname, String args) {
        ServiceManager serviceManager = manager;
        synchronized (serviceManager) {
            block8: {
                ServiceDesc desc = ServiceManager.manager.registry.get(scname);
                if (xlogmon.isLoggable(BasicLevel.DEBUG)) {
                    xlogmon.log(BasicLevel.DEBUG, (Object)(ServiceManager.getName() + ", register " + scname + " -> " + desc));
                }
                if (desc == null) {
                    desc = new ServiceDesc(scname, args);
                    ServiceManager.manager.registry.put(scname, desc);
                } else {
                    desc.args = args;
                }
                try {
                    ServiceManager.save();
                }
                catch (IOException e) {
                    if (!xlogmon.isLoggable(BasicLevel.ERROR)) break block8;
                    xlogmon.log(BasicLevel.ERROR, (Object)(ServiceManager.getName() + ", register save service manager." + scname), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unregister(String scname) {
        if (xlogmon.isLoggable(BasicLevel.DEBUG)) {
            xlogmon.log(BasicLevel.DEBUG, (Object)(ServiceManager.getName() + ", unregister " + scname));
        }
        ServiceManager serviceManager = manager;
        synchronized (serviceManager) {
            block6: {
                ServiceManager.manager.registry.remove(scname);
                try {
                    ServiceManager.save();
                }
                catch (IOException e) {
                    if (!xlogmon.isLoggable(BasicLevel.ERROR)) break block6;
                    xlogmon.log(BasicLevel.ERROR, (Object)(ServiceManager.getName() + ", unregister save service manager." + scname), (Throwable)e);
                }
            }
        }
    }

    public static ServiceDesc getService(String serviceClassName) {
        return ServiceManager.manager.registry.get(serviceClassName);
    }

    static ServiceDesc[] getServices() {
        ServiceDesc[] services = new ServiceDesc[ServiceManager.manager.registry.size()];
        int i = 0;
        Enumeration<ServiceDesc> e = ServiceManager.manager.registry.elements();
        while (e.hasMoreElements()) {
            services[i++] = e.nextElement();
        }
        return services;
    }

    static Set<String> listServices() {
        return new HashSet<String>(ServiceManager.manager.registry.keySet());
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append('(');
        output.append(super.toString());
        output.append(",registry=").append(Strings.toString(this.registry));
        output.append(')');
        return output.toString();
    }

    static {
        xlogmon = null;
        name = null;
        txname = "serviceManager";
    }
}

