/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.Message;
import fr.dyade.aaa.agent.MessageQueue;
import fr.dyade.aaa.agent.MessageSoftRef;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.common.EmptyQueueException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

final class MessageVector
implements MessageQueue {
    private Logger logmon = null;
    private String logmsg = null;
    private long cpt1;
    private long cpt2;
    private Object[] data;
    private int first;
    private int count;
    private int validated;
    private boolean persistent;
    public static final String MSG_TYPES_TRACKING = "fr.dyade.aaa.agent.MsgTypesTracking";
    private static boolean msgTypesTracking = AgentServer.getBoolean("fr.dyade.aaa.agent.MsgTypesTracking");
    Hashtable<Class, Counter> counters = null;

    MessageVector(String name, boolean persistent) {
        this.logmon = Debug.getLogger(this.getClass().getName() + '.' + name);
        this.logmsg = name + ".MessageVector: ";
        if (msgTypesTracking) {
            this.counters = new Hashtable();
        }
        this.persistent = persistent;
        this.data = new Object[50];
        this.first = 0;
        this.count = 0;
        this.validated = 0;
    }

    @Override
    public synchronized void insert(Message item) {
        int i;
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "insert(" + item + ")"));
        }
        for (i = 0; i < this.validated; ++i) {
            Message msg = this.getMessageAt(i);
            if (item.getStamp() < msg.getStamp()) break;
        }
        this.insertMessageAt(item, i);
        ++this.validated;
    }

    @Override
    public synchronized void push(Message item) {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "push(" + item + ")"));
        }
        if (msgTypesTracking) {
            this.inc(item.not);
        }
        this.insertMessageAt(item, this.count);
    }

    @Override
    public synchronized void pushAndValidate(Message item) {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "pushAndValidate(" + item + ")"));
        }
        if (msgTypesTracking) {
            this.inc(item.not);
        }
        this.insertMessageAt(item, this.validated);
        ++this.validated;
        this.notify();
    }

    @Override
    public synchronized Message pop() throws EmptyQueueException {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "pop()"));
        }
        if (this.validated == 0) {
            throw new EmptyQueueException();
        }
        Message item = this.getMessageAt(0);
        if (msgTypesTracking) {
            this.dec(item.not);
        }
        this.removeMessageAt(0);
        --this.validated;
        return item;
    }

    @Override
    public synchronized void validate() {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "validate()"));
        }
        this.validated = this.size();
        this.notify();
    }

    @Override
    public synchronized Message get() throws InterruptedException {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "get()"));
            ++this.cpt1;
            this.cpt2 += (long)this.validated;
            if ((this.cpt1 & 0xFFFFL) == 0L) {
                this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + this.cpt2 / this.cpt1 + '/' + this.validated));
            }
        }
        while (this.validated == 0) {
            this.wait();
        }
        Message item = this.getMessageAt(0);
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "get() -> " + item));
        }
        return item;
    }

    @Override
    public synchronized Message get(long timeout) throws InterruptedException {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "get(" + timeout + ")"));
            ++this.cpt1;
            this.cpt2 += (long)this.validated;
            if ((this.cpt1 & 0xFFFFL) == 0L) {
                this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + this.cpt2 / this.cpt1 + '/' + this.validated));
            }
        }
        Message item = null;
        if (this.validated == 0 && timeout > 0L) {
            this.wait(timeout);
        }
        if (this.validated > 0) {
            item = this.getMessageAt(0);
        }
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "get() -> " + item));
        }
        return item;
    }

    public synchronized Message getMessageTo(short to) {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "getFrom(" + to + ")"));
            ++this.cpt1;
            this.cpt2 += (long)this.validated;
            if ((this.cpt1 & 0xFFFFL) == 0L) {
                this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + this.cpt2 / this.cpt1 + '/' + this.validated));
            }
        }
        Message item = null;
        for (int i = 0; i < this.validated; ++i) {
            Message msg = this.getMessageAt(i);
            if (msg.getDest() != to) continue;
            item = msg;
            break;
        }
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "get() -> " + item));
        }
        return item;
    }

    synchronized void removeMessage(Message msg) {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "removeMessage #" + msg.getStamp()));
        }
        for (int i = 0; i < this.validated; ++i) {
            if (this.getMessageAt(i) != msg) continue;
            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "removeMessage #" + msg.getStamp() + " -> " + i));
            }
            this.removeMessageAt(i);
            --this.validated;
            return;
        }
        this.logmon.log(BasicLevel.ERROR, (Object)(this.logmsg + "removeMessage #" + msg.getStamp() + " not found"));
    }

    synchronized int remove(int stamp) {
        Message msg;
        int i;
        if (this.validated == 0) {
            return 0;
        }
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "remove #" + stamp));
        }
        for (i = 0; i < this.validated && stamp >= (msg = this.getMessageAt(i)).getStamp(); ++i) {
        }
        for (int j = 0; j < i; ++j) {
            this.removeMessageAt(0);
        }
        this.validated -= i;
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "remove #" + stamp + " ->" + i));
        }
        return i;
    }

    synchronized Message removeExpired(long currentTimeMillis) {
        if (this.validated == 0) {
            return null;
        }
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "removeExpired - " + currentTimeMillis));
        }
        for (int i = 0; i < this.validated; ++i) {
            Message msg = this.getMessageAt(i);
            if (msg.not == null || msg.not.expiration <= 0L || currentTimeMillis < msg.not.expiration) continue;
            this.removeMessageAt(i);
            --this.validated;
            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "remove #" + msg.getStamp()));
            }
            return msg;
        }
        return null;
    }

    private void insertMessageAt(Message item, int index) {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "insertMessageAt(" + item + ", " + index + ")"));
        }
        if (this.count == this.data.length) {
            Object[] newData = new Object[this.data.length * 2];
            if (this.first + this.count < this.data.length) {
                System.arraycopy(this.data, this.first, newData, 0, this.count);
            } else {
                int j = this.data.length - this.first;
                System.arraycopy(this.data, this.first, newData, 0, j);
                System.arraycopy(this.data, 0, newData, j, this.count - j);
            }
            this.first = 0;
            this.data = newData;
        }
        if (index != this.count) {
            try {
                int srcPos = (this.first + index) % this.data.length;
                int destPos = (this.first + index + 1) % this.data.length;
                int copyLength = this.count - index;
                int lastDestPos = (destPos + copyLength - 1) % this.data.length;
                if (srcPos > lastDestPos) {
                    int copyLength2;
                    Object lastElement = this.data[this.data.length - 1];
                    int copyLength1 = this.data.length - srcPos - 1;
                    if (copyLength1 > 0) {
                        System.arraycopy(this.data, srcPos, this.data, destPos, copyLength1);
                    }
                    if ((copyLength2 = copyLength - (copyLength1 + 1)) > 0) {
                        System.arraycopy(this.data, 0, this.data, 1, copyLength2);
                    }
                    this.data[0] = lastElement;
                } else {
                    System.arraycopy(this.data, srcPos, this.data, destPos, copyLength);
                }
            }
            catch (ArrayIndexOutOfBoundsException exc) {
                throw new RuntimeException("insertMessageAt '" + index + "': " + this, exc);
            }
        }
        this.data[(this.first + index) % this.data.length] = this.persistent ? new MessageSoftRef(item) : item;
        ++this.count;
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "insertMessageAt() -> " + this));
        }
    }

    private Message getMessageAt(int index) {
        int idx;
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "getMessageAt(" + index + ")"));
        }
        if (this.data[idx = (this.first + index) % this.data.length] == null) {
            throw new RuntimeException("Null element in: " + this);
        }
        if (this.persistent) {
            return ((MessageSoftRef)this.data[idx]).loadMessage();
        }
        return (Message)this.data[idx];
    }

    private void removeMessageAt(int index) {
        if (index == 0) {
            this.data[this.first] = null;
            this.first = (this.first + 1) % this.data.length;
        } else if (index == this.count - 1) {
            this.data[(this.first + index) % this.data.length] = null;
        } else if (this.first + index < this.data.length) {
            System.arraycopy(this.data, this.first, this.data, this.first + 1, index);
            this.data[this.first] = null;
            this.first = (this.first + 1) % this.data.length;
        } else {
            System.arraycopy(this.data, (this.first + index) % this.data.length + 1, this.data, (this.first + index) % this.data.length, this.count - index - 1);
            this.data[(this.first + this.count - 1) % this.data.length] = null;
        }
        --this.count;
        if (this.count == 0) {
            this.first = 0;
        }
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "removeMessageAt(" + index + ") -> " + this));
        }
    }

    @Override
    public int size() {
        return this.count;
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append('(').append(super.toString());
        strbuf.append(",first=").append(this.first);
        strbuf.append(",count=").append(this.count);
        strbuf.append(",validated=").append(this.validated).append(",(");
        for (int i = 0; i < this.data.length; ++i) {
            strbuf.append(this.data[i]).append(',');
        }
        strbuf.append("))");
        return strbuf.toString();
    }

    private void inc(Notification not) {
        if (not == null) {
            return;
        }
        Counter counter = this.counters.get(not.getClass());
        if (counter == null) {
            this.counters.put(not.getClass(), new Counter());
        } else {
            ++counter.total;
            ++counter.live;
        }
    }

    private void dec(Notification not) {
        if (not == null) {
            return;
        }
        Counter counter = this.counters.get(not.getClass());
        --counter.live;
    }

    @Override
    public String report() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("waiting=").append(this.size()).append('\n');
        if (this.size() != 0 && this.counters != null) {
            Enumeration<Class> e = this.counters.keys();
            while (e.hasMoreElements()) {
                Class clazz = e.nextElement();
                Counter counter = this.counters.get(clazz);
                if (counter == null) continue;
                strbuf.append(clazz.getName()).append('=').append(counter.live).append('/').append(counter.total).append('\n');
            }
        }
        return strbuf.toString();
    }

    static class Counter {
        int total = 1;
        int live = 1;

        Counter() {
        }
    }
}

