/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.Debug;
import fr.dyade.aaa.agent.Message;
import java.lang.ref.SoftReference;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public final class MessageSoftRef {
    private static final Logger logmon = Debug.getLogger(MessageSoftRef.class.getName());
    private String name = null;
    private Message ref = null;
    private SoftReference<Message> softRef = null;
    private int stamp;
    private String messageId;
    private long expiration;
    private AgentId deadNotAgentId;

    MessageSoftRef(Message msg) {
        this.softRef = new SoftReference<Message>(msg);
        this.stamp = msg.stamp;
        if (msg.not != null) {
            this.expiration = msg.not.expiration;
            this.deadNotAgentId = msg.not.deadNotificationAgentId;
        }
        if (msg.isPersistent()) {
            this.name = msg.toStringId();
            if (msg.not.detachable && !msg.not.detached) {
                this.messageId = msg.not.getMessageId();
            }
        } else {
            this.ref = msg;
        }
    }

    public boolean isExpired(long time) {
        return this.expiration > 0L && this.expiration < time;
    }

    public AgentId getDeadNotAgentId() {
        return this.deadNotAgentId;
    }

    public Message getMessage() {
        return this.ref == null ? this.softRef.get() : this.ref;
    }

    public int getStamp() {
        return this.stamp;
    }

    public Message loadMessage() throws TransactionError {
        Message msg = this.getMessage();
        if (msg == null) {
            try {
                msg = Message.load(this.name);
                this.softRef = new SoftReference<Message>(msg);
                if (logmon.isLoggable(BasicLevel.DEBUG)) {
                    logmon.log(BasicLevel.DEBUG, (Object)("SoftReference: reload from disk " + msg));
                }
            }
            catch (Exception exc) {
                logmon.log(BasicLevel.ERROR, (Object)("SoftReference: Can't load message " + this.name), (Throwable)exc);
                throw new TransactionError(exc);
            }
        }
        return msg;
    }

    public void delete() {
        if (this.name != null) {
            Message msg = this.softRef.get();
            if (msg != null) {
                msg.delete();
                msg.free();
            } else {
                AgentServer.getTransaction().delete(this.name);
                if (this.messageId != null) {
                    AgentServer.getTransaction().delete(this.messageId);
                }
            }
        }
    }

    public String toString() {
        return "msgSoft#" + this.stamp;
    }

    static final class TransactionError
    extends Error {
        private static final long serialVersionUID = 1L;

        TransactionError(Throwable cause) {
            super(cause.getMessage());
        }
    }
}

