/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.Debug;
import fr.dyade.aaa.agent.Message;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.common.BinaryDump;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.zip.GZIPInputStream;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public abstract class MessageInputStream
extends InputStream {
    protected byte[] buf;
    protected int count;
    protected int pos;
    protected boolean compressedFlows = false;
    protected static Logger logmon = null;

    protected static Logger getLogger() {
        if (logmon == null) {
            logmon = Debug.getLogger("fr.dyade.aaa.agent.MessageInputStream");
        }
        return logmon;
    }

    MessageInputStream() {
    }

    @Override
    public abstract int read() throws IOException;

    @Override
    public final int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public abstract int read(byte[] var1, int var2, int var3) throws IOException;

    protected final short readShort() {
        return (short)(((this.buf[this.pos++] & 0xFF) << 8) + (this.buf[this.pos++] & 0xFF));
    }

    protected final int readInt() {
        return ((this.buf[this.pos++] & 0xFF) << 24) + ((this.buf[this.pos++] & 0xFF) << 16) + ((this.buf[this.pos++] & 0xFF) << 8) + ((this.buf[this.pos++] & 0xFF) << 0);
    }

    protected abstract void readHeader() throws IOException;

    protected final void readMessageHeader(Message msg) throws IOException {
        if (MessageInputStream.getLogger().isLoggable(BasicLevel.DEBUG)) {
            MessageInputStream.getLogger().log(BasicLevel.DEBUG, (Object)"readMessageHeader()");
        }
        this.readFully(25);
        if (MessageInputStream.getLogger().isLoggable(BasicLevel.DEBUG)) {
            MessageInputStream.getLogger().log(BasicLevel.DEBUG, (Object)("readMessageHeader-1 : " + BinaryDump.toHex(this.buf, this.pos, 25)));
        }
        msg.from = new AgentId(this.readShort(), this.readShort(), this.readInt());
        msg.to = new AgentId(this.readShort(), this.readShort(), this.readInt());
        msg.source = this.readShort();
        msg.dest = this.readShort();
        msg.stamp = this.readInt();
        if (MessageInputStream.getLogger().isLoggable(BasicLevel.DEBUG)) {
            MessageInputStream.getLogger().log(BasicLevel.DEBUG, (Object)"readMessageHeader returns");
        }
    }

    protected final Message readMessage() throws Exception {
        if (MessageInputStream.getLogger().isLoggable(BasicLevel.DEBUG)) {
            MessageInputStream.getLogger().log(BasicLevel.DEBUG, (Object)"readMessage()");
        }
        this.readHeader();
        Message msg = Message.alloc();
        this.readMessageHeader(msg);
        byte opt = this.buf[this.pos++];
        if (opt != 0) {
            ObjectInputStream ois = null;
            if (this.compressedFlows) {
                int count;
                this.readFully(4);
                int length = this.readInt();
                if (MessageInputStream.getLogger().isLoggable(BasicLevel.DEBUG)) {
                    MessageInputStream.getLogger().log(BasicLevel.DEBUG, (Object)("readMessage - length=" + length));
                }
                byte[] buf = new byte[length];
                int n = 0;
                do {
                    if ((count = this.read(buf, n, length - n)) >= 0) continue;
                    throw new EOFException();
                } while ((n += count) < length);
                ois = new ObjectInputStream(new GZIPInputStream(new ByteArrayInputStream(buf)));
            } else {
                ois = new ObjectInputStream(this);
            }
            if (MessageInputStream.getLogger().isLoggable(BasicLevel.DEBUG)) {
                MessageInputStream.getLogger().log(BasicLevel.DEBUG, (Object)"readMessage - 2");
            }
            msg.not = (Notification)ois.readObject();
            if (MessageInputStream.getLogger().isLoggable(BasicLevel.DEBUG)) {
                MessageInputStream.getLogger().log(BasicLevel.DEBUG, (Object)"readMessage - 3");
            }
            if (msg.not.expiration > 0L) {
                msg.not.expiration += System.currentTimeMillis();
            }
            msg.optFromByte(opt);
            msg.not.detached = false;
            if (!this.compressedFlows) {
                this.read();
            }
            if (MessageInputStream.getLogger().isLoggable(BasicLevel.DEBUG)) {
                MessageInputStream.getLogger().log(BasicLevel.DEBUG, (Object)"readMessage - 4");
            }
        } else {
            msg.not = null;
        }
        if (MessageInputStream.getLogger().isLoggable(BasicLevel.DEBUG)) {
            MessageInputStream.getLogger().log(BasicLevel.DEBUG, (Object)"readMessage returns");
        }
        return msg;
    }

    protected abstract void readFully(int var1) throws IOException;
}

