/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.Callback;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class CountDownCallback {
    private AtomicInteger countDown;
    private List<Throwable> errors;
    private Callback callback;

    public CountDownCallback(Callback callback) {
        if (AgentServer.isEngineThread()) {
            throw new RuntimeException("Not permitted: the current thread belongs to the Engine");
        }
        this.callback = callback;
        this.countDown = new AtomicInteger();
    }

    void incrementAndGet() {
        this.countDown.incrementAndGet();
    }

    void done() {
        int count = this.countDown.decrementAndGet();
        if (count == 0) {
            if (this.errors != null) {
                this.callback.failed(this.errors);
            } else {
                this.callback.done();
            }
        }
    }

    void failed(Throwable error) {
        if (this.errors == null) {
            this.errors = new ArrayList<Throwable>(this.countDown.get());
        }
        this.errors.add(error);
        int count = this.countDown.decrementAndGet();
        if (count == 0) {
            this.callback.failed(this.errors);
        }
    }
}

