/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentEngine;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.CheckServerListener;
import fr.dyade.aaa.agent.Debug;
import fr.dyade.aaa.util.Transaction;
import java.util.Date;
import java.util.TimerTask;
import java.util.Vector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

class CheckServerTask
extends TimerTask {
    private static Logger logmon = Debug.getLogger(AgentServer.class.getName());
    long dtwarn;
    long dterr;
    long lastThrow = -1L;
    AgentEngine engine = AgentServer.getEngine();
    Transaction transaction = AgentServer.getTransaction();
    Vector<CheckServerListener> listeners = null;
    long lastEngineChangeDate = -1L;
    long lastEngineWarnDate = -1L;
    long reactCount = 0L;
    int commitCount = 0;
    long lastTransactionChangeDate = -1L;
    long lastTransactionWarnDate = -1L;

    CheckServerTask(long dterr) {
        if (dterr < 10000L) {
            dterr = 10000L;
            logmon.log(BasicLevel.WARN, (Object)(AgentServer.getName() + " checkServer period cannot be less than 10s."));
        }
        this.dtwarn = dterr / 5L;
        this.dterr = dterr;
        this.listeners = new Vector();
    }

    public synchronized void registerListener(CheckServerListener listener) {
        logmon.log(BasicLevel.INFO, (Object)(AgentServer.getName() + " registers listener for CheckServer."));
        this.listeners.addElement(listener);
    }

    public synchronized void unregisterListener(CheckServerListener listener) {
        logmon.log(BasicLevel.INFO, (Object)(AgentServer.getName() + " unregisters listener for CheckServer."));
        this.listeners.removeElement(listener);
    }

    private synchronized void throwListeners() {
        for (CheckServerListener listener : this.listeners) {
            logmon.log(BasicLevel.DEBUG, (Object)(AgentServer.getName() + " calls listener for CheckServer."));
            listener.onServerCheckError();
        }
    }

    @Override
    public void run() {
        long now = System.currentTimeMillis();
        if (this.engine == null || this.transaction == null) {
            logmon.log(BasicLevel.ERROR, (Object)(AgentServer.getName() + " not initialized."));
            this.throwListeners();
        }
        if ((this.checkEngine(now) || this.checkTransaction(now)) && now - this.lastThrow > this.dterr) {
            this.throwListeners();
            this.lastThrow = now;
        }
    }

    private boolean idleEngine() {
        return this.engine.getRunningAgent() == null && this.engine.getNbWaitingMessages() == 0;
    }

    private boolean checkEngine(long now) {
        logmon.log(BasicLevel.DEBUG, (Object)(AgentServer.getName() + ".checkEngine():" + this.engine.getNbReactions() + ", " + this.reactCount));
        if (this.engine.getNbReactions() > this.reactCount) {
            this.reactCount = this.engine.getNbReactions();
            this.lastEngineChangeDate = now;
            return false;
        }
        if (!this.engine.isRunning()) {
            if (now - this.lastEngineChangeDate > this.dtwarn && now - this.lastEngineWarnDate > this.dtwarn) {
                logmon.log(BasicLevel.WARN, (Object)(AgentServer.getName() + ", engine is not running."));
                this.lastEngineWarnDate = now;
            }
            return false;
        }
        if (this.idleEngine()) {
            if (now - this.lastEngineChangeDate > this.dtwarn && now - this.lastEngineWarnDate > this.dtwarn) {
                logmon.log(BasicLevel.WARN, (Object)(AgentServer.getName() + ", engine is idle."));
                this.lastEngineWarnDate = now;
            }
            return false;
        }
        if (now - this.lastEngineChangeDate > this.dterr && now - this.lastEngineWarnDate > this.dtwarn) {
            logmon.log(BasicLevel.ERROR, (Object)(AgentServer.getName() + ", the engine doesn't progress since " + new Date(this.lastEngineChangeDate)));
            this.lastEngineWarnDate = now;
            return true;
        }
        if (now - this.lastEngineChangeDate > this.dtwarn && now - this.lastEngineWarnDate > this.dtwarn) {
            logmon.log(BasicLevel.WARN, (Object)(AgentServer.getName() + ", the engine doesn't progress since " + new Date(this.lastEngineChangeDate)));
            this.lastEngineWarnDate = now;
            return false;
        }
        return false;
    }

    private boolean checkTransaction(long now) {
        logmon.log(BasicLevel.DEBUG, (Object)(AgentServer.getName() + ".checkTransaction()" + this.transaction.getCommitCount() + ", " + this.commitCount + "," + this.transaction.getPhase()));
        if (this.transaction.getCommitCount() > this.commitCount) {
            this.commitCount = this.transaction.getCommitCount();
            this.lastTransactionChangeDate = now;
            return false;
        }
        if (this.transaction.getPhase() == 1) {
            this.lastTransactionChangeDate = now;
            return false;
        }
        if (now - this.lastTransactionChangeDate > this.dterr && now - this.lastTransactionWarnDate > this.dtwarn) {
            logmon.log(BasicLevel.ERROR, (Object)(AgentServer.getName() + ", Transaction doesn't progress since " + new Date(this.lastTransactionChangeDate)));
            this.lastTransactionWarnDate = now;
        } else if (now - this.lastTransactionChangeDate > this.dtwarn && now - this.lastTransactionWarnDate > this.dtwarn) {
            logmon.log(BasicLevel.WARN, (Object)(AgentServer.getName() + ", Transaction doesn't progress since " + new Date(this.lastTransactionChangeDate)));
            this.lastTransactionWarnDate = now;
        }
        return true;
    }
}

