/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent.services;

import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.ServerDesc;
import fr.dyade.aaa.common.Debug;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationException;
import org.ow2.util.substitution.IPropertyResolver;
import org.ow2.util.substitution.ISubstitutionEngine;
import org.ow2.util.substitution.engine.DefaultSubstitutionEngine;
import org.ow2.util.substitution.resolver.ChainedResolver;
import org.ow2.util.substitution.resolver.PropertiesResolver;
import org.ow2.util.substitution.resolver.RecursiveResolver;

public class CommonService {
    public static final Logger logmon = Debug.getLogger((String)CommonService.class.getName());
    public static final String SID = "sid";
    public static final String STORAGE = "storage";
    public static final String PATH_TO_CONF = "pathToConf";
    private short sid = 0;
    private String path = "s0";
    protected BundleContext bundleContext;

    public CommonService(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    protected void doStart() throws Exception {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, "CommonService.doStart()");
        }
        try {
            AgentServer.init((short)this.sid, (String)this.path, null);
        }
        catch (Exception exc) {
            logmon.log(BasicLevel.ERROR, AgentServer.getName() + " initialization failed", (Throwable)exc);
            throw exc;
        }
        try {
            String errStr = AgentServer.start();
            if (errStr == null) {
                if (logmon.isLoggable(BasicLevel.INFO)) {
                    logmon.log(BasicLevel.INFO, AgentServer.getName() + " started: " + "OK");
                }
            } else if (logmon.isLoggable(BasicLevel.INFO)) {
                logmon.log(BasicLevel.INFO, AgentServer.getName() + " started: " + "ERROR" + "\n" + errStr + "\n" + "END");
            }
        }
        catch (Exception exc) {
            logmon.log(BasicLevel.ERROR, AgentServer.getName() + " failed", (Throwable)exc);
            throw exc;
        }
        ServerDesc serverDesc = AgentServer.getServerDesc((short)this.sid);
        Properties props = new Properties();
        props.setProperty(SID, "" + this.sid);
        props.setProperty("name", serverDesc.getServerName());
        props.setProperty("host", serverDesc.getHostname());
        props.setProperty("port", "" + serverDesc.getPort());
        this.bundleContext.registerService(ServerDesc.class.getName(), (Object)serverDesc, (Dictionary)props);
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, "CommonService ServerDesc register: " + serverDesc);
        }
    }

    protected void doStop() {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, "CommonService.doStop(): AgentServer status = " + AgentServer.getStatusInfo());
        }
        if (AgentServer.getStatus() == 3 || AgentServer.getStatus() == 4) {
            AgentServer.stop();
            AgentServer.reset();
        }
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        String pathToConf;
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, "updated(" + properties + ')');
        }
        if (properties == null) {
            this.doStop();
            return;
        }
        String sidStr = (String)properties.get(SID);
        if (sidStr != null && sidStr.length() > 0) {
            this.sid = new Short(sidStr);
        }
        DefaultSubstitutionEngine engine = new DefaultSubstitutionEngine();
        ChainedResolver resolver = new ChainedResolver();
        resolver.getResolvers().add(new PropertiesResolver(System.getProperties()));
        engine.setResolver((IPropertyResolver)new RecursiveResolver((ISubstitutionEngine)engine, (IPropertyResolver)resolver));
        String storage = (String)properties.get(STORAGE);
        if (storage != null && storage.length() > 0) {
            this.path = engine.substitute(storage);
        }
        if ((pathToConf = (String)properties.get(PATH_TO_CONF)) != null && pathToConf.length() > 0) {
            System.setProperty("fr.dyade.aaa.agent.A3CONF_DIR", engine.substitute(pathToConf));
        }
        Enumeration en = properties.keys();
        while (en.hasMoreElements()) {
            Object value;
            Object key = en.nextElement();
            if (SID.equals(key) || STORAGE.equals(key) || PATH_TO_CONF.equals(key) || (value = properties.get(key)) == null || !(key instanceof String) || !(value instanceof String)) continue;
            System.setProperty((String)key, (String)value);
        }
        try {
            this.doStart();
        }
        catch (Exception e) {
            if (logmon.isLoggable(BasicLevel.ERROR)) {
                logmon.log(BasicLevel.ERROR, "updated:: doStart EXCEPTION", (Throwable)e);
            }
            throw new ConfigurationException(null, e.getMessage());
        }
    }
}

