/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.common.encoding;

import fr.dyade.aaa.common.encoding.Decoder;
import fr.dyade.aaa.common.encoding.Encodable;
import fr.dyade.aaa.common.encoding.EncodableFactory;
import fr.dyade.aaa.common.encoding.Encoder;
import fr.dyade.aaa.common.encoding.MigrationControlInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class SerializableWrapper
implements Encodable {
    private Serializable value;
    private byte[] bytes;

    public SerializableWrapper() {
    }

    public SerializableWrapper(Serializable value) {
        this.value = value;
    }

    public Serializable getValue() {
        return this.value;
    }

    @Override
    public int getEncodableClassId() {
        return 1;
    }

    @Override
    public int getEncodedSize() throws Exception {
        this.serialize();
        return 4 + this.bytes.length;
    }

    private void serialize() throws Exception {
        if (this.bytes == null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            try {
                oos.writeObject(this.value);
                this.bytes = baos.toByteArray();
            }
            finally {
                baos.close();
                oos.close();
            }
        }
    }

    @Override
    public void encode(Encoder encoder) throws Exception {
        this.serialize();
        encoder.encodeByteArray(this.bytes);
    }

    @Override
    public void decode(Decoder decoder) throws Exception {
        byte[] bytes = decoder.decodeByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        MigrationControlInputStream ois = new MigrationControlInputStream(bais);
        this.value = (Serializable)ois.readObject();
    }

    public static class Factory
    implements EncodableFactory {
        @Override
        public Encodable createEncodable() {
            return new SerializableWrapper();
        }
    }
}

