/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.slf4j;

import org.objectweb.util.monolog.api.Level;
import org.objectweb.util.monolog.slf4j.LevelDebug;
import org.objectweb.util.monolog.slf4j.LevelError;
import org.objectweb.util.monolog.slf4j.LevelInfo;
import org.objectweb.util.monolog.slf4j.LevelOff;
import org.objectweb.util.monolog.slf4j.LevelTrace;
import org.objectweb.util.monolog.slf4j.LevelWarn;
import org.objectweb.util.monolog.slf4j.Slf4jMonologLevel;

class Slf4jMonologLevels {
    static final Slf4jMonologLevel ERROR = new LevelError();
    static final Slf4jMonologLevel WARN = new LevelWarn();
    static final Slf4jMonologLevel INFO = new LevelInfo();
    static final Slf4jMonologLevel DEBUG = new LevelDebug();
    static final Slf4jMonologLevel TRACE = new LevelTrace();
    static final Slf4jMonologLevel OFF = new LevelOff();
    private static final Slf4jMonologLevel[] VALUES = new Slf4jMonologLevel[]{ERROR, WARN, INFO, DEBUG, TRACE, OFF};

    static Slf4jMonologLevel of(String name) {
        if (null == name) {
            return null;
        }
        switch (name.toUpperCase()) {
            case "OFF": {
                return OFF;
            }
            case "FATAL": 
            case "ERROR": {
                return ERROR;
            }
            case "WARNING": 
            case "WARN": {
                return WARN;
            }
            case "CONFIG": 
            case "INFO": {
                return INFO;
            }
            case "FINE": 
            case "DEBUG": {
                return DEBUG;
            }
            case "TRACE": 
            case "FINER": 
            case "FINEST": 
            case "ALL": {
                return TRACE;
            }
        }
        return null;
    }

    static Slf4jMonologLevel of(Level level) {
        if (level instanceof Slf4jMonologLevel) {
            return (Slf4jMonologLevel)level;
        }
        if (null == level) {
            return DEBUG;
        }
        int lvl = level.intValue();
        for (Slf4jMonologLevel l : VALUES) {
            if (lvl < l.intValue()) continue;
            return l;
        }
        return OFF;
    }

    Slf4jMonologLevels() {
    }
}

