/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.common.monitoring;

import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.common.monitoring.MonitoringTimerTask;
import java.util.Properties;
import java.util.Timer;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class LogMonitoringTimerTask
extends MonitoringTimerTask {
    public static final String MONITORING_CONFIG_PERIOD_PROPERTY = "org.ow2.joram.monitoring.LOG_CONFIG_PERIOD";
    public static final long DEFAULT_MONITORING_CONFIG_PERIOD = 60000L;
    public static final String MONITORING_CONFIG_PATH_PROPERTY = "org.ow2.joram.monitoring.LOG_CONFIG_PATH";
    public static final String DEFAULT_MONITORING_CONFIG_PATH = "logMonitoring.props";
    public static final String MONITORING_RESULT_LOGGER_PROPERTY = "org.ow2.joram.monitoring.LOG_RESULT_LOGGER";
    public static final String DEFAULT_MONITORING_RESULT_LOGGER = "fr.dyade.aaa.Monitoring";
    public static final String MONITORING_RESULT_LEVEL_PROPERTY = "org.ow2.joram.monitoring.LOG_RESULT_LEVEL";
    public static final int DEFAULT_MONITORING_RESULT_LEVEL = BasicLevel.getIntLevel(BasicLevel.WARN);
    public static final String MONITORING_RESULT_MESSAGE_PROPERTY = "org.ow2.joram.monitoring.LOG_RESULT_MESSAGE";
    public static final String DEFAULT_MONITORING_RESULT_MESSAGE = "JMX Monitoring ";
    Logger monitoringLogger;
    String msg;
    int level;
    StringBuffer strbuf = null;

    public LogMonitoringTimerTask(Timer timer, long period, Properties attlist, Logger logger, String msg, int level) {
        super(period, attlist);
        this.monitoringLogger = logger;
        this.msg = msg;
        this.level = level;
        this.strbuf = new StringBuffer();
        this.start(timer);
    }

    public LogMonitoringTimerTask() {
    }

    @Override
    public void init(Timer timer, long period, Properties attlist, Properties taskProps) {
        this.timerPeriod = period;
        this.attlist = (Properties)attlist.clone();
        this.monitoringLogger = Debug.getLogger(taskProps.getProperty("result.logger"));
        this.msg = taskProps.getProperty("log.message");
        this.level = BasicLevel.parse(taskProps.getProperty("log.level")).intValue();
        this.strbuf = new StringBuffer();
        this.start(timer);
    }

    @Override
    protected void initializeRecords() {
        this.strbuf.append(this.msg).append('[');
    }

    @Override
    protected void addRecord(String mbean, String att, Object value) {
        this.strbuf.append('(').append(mbean).append(':').append(att).append('=').append(value).append(')');
    }

    @Override
    protected void finalizeRecords() {
        this.strbuf.append(']');
        this.monitoringLogger.log(BasicLevel.fromIntLevel(this.level), this.strbuf.toString());
        this.strbuf.setLength(0);
    }

    protected int getLevel(String levelName) {
        int level;
        block3: {
            level = DEFAULT_MONITORING_RESULT_LEVEL;
            try {
                if (levelName != null) {
                    level = Integer.parseInt(levelName);
                }
            }
            catch (Exception e) {
                level = BasicLevel.getIntLevel(levelName);
                if (level != BasicLevel.BADLEVEL) break block3;
                logger.log(BasicLevel.ERROR, "LogMonitoringTimerTask getLevel: bad levelName " + levelName);
            }
        }
        return level;
    }
}

