/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.slf4j;

import org.objectweb.util.monolog.api.Level;
import org.objectweb.util.monolog.api.LoggingFactory;
import org.objectweb.util.monolog.slf4j.Slf4jLoggerLevelSetter;
import org.objectweb.util.monolog.slf4j.Slf4jMonologLevels;
import org.objectweb.util.monolog.slf4j.Slf4jMonologLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jMonologFactory
implements LoggingFactory {
    private static Slf4jLoggerLevelSetter runtimeReconfiguration = Slf4jLoggerLevelSetter.unavailableFeature();

    @Override
    public void initialize(String debugDir, String debugFileName) {
    }

    @Override
    public org.objectweb.util.monolog.api.Logger getLogger(String topic) {
        Logger slf4jLogger = LoggerFactory.getLogger((String)topic);
        return new Slf4jMonologLogger(slf4jLogger, runtimeReconfiguration);
    }

    @Override
    public Level getFatalLevel() {
        return Slf4jMonologLevels.ERROR;
    }

    @Override
    public Level getErrorLevel() {
        return Slf4jMonologLevels.ERROR;
    }

    @Override
    public Level getWarnLevel() {
        return Slf4jMonologLevels.WARN;
    }

    @Override
    public Level getInfoLevel() {
        return Slf4jMonologLevels.INFO;
    }

    @Override
    public Level getDebugLevel() {
        return Slf4jMonologLevels.DEBUG;
    }

    @Override
    public Level parse(String name) {
        return Slf4jMonologLevels.of(name);
    }

    public static void setRuntimeReconfiguration(Slf4jLoggerLevelSetter runtimeReconfiguration) {
        if (null != runtimeReconfiguration) {
            Slf4jMonologFactory.runtimeReconfiguration = runtimeReconfiguration;
        }
    }
}

