/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.common.monitoring;

import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.common.monitoring.MonitoringTimerTaskMBean;
import fr.dyade.aaa.util.management.MXWrapper;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public abstract class MonitoringTimerTask
extends TimerTask
implements MonitoringTimerTaskMBean {
    public static Logger logger = Debug.getLogger(MonitoringTimerTask.class.getName());
    protected long timerPeriod;
    Properties attlist = null;
    public String mbeanName = null;

    @Override
    public long getPeriod() {
        return this.timerPeriod;
    }

    public MonitoringTimerTask(long period, Properties attlist) {
        this.timerPeriod = period;
        this.attlist = attlist;
    }

    public MonitoringTimerTask() {
    }

    public abstract void init(Timer var1, long var2, Properties var4, Properties var5);

    protected final void start(Timer timer) {
        timer.scheduleAtFixedRate((TimerTask)this, 0L, this.timerPeriod);
    }

    protected abstract void initializeRecords();

    protected abstract void addRecord(String var1, String var2, Object var3);

    protected abstract void finalizeRecords();

    @Override
    public void run() {
        this.initializeRecords();
        Enumeration<Object> mbeans = this.attlist.keys();
        while (mbeans.hasMoreElements()) {
            String name = (String)mbeans.nextElement();
            Set<String> mBeans = null;
            try {
                mBeans = MXWrapper.queryNames(name);
            }
            catch (Exception exc) {
                logger.log(BasicLevel.ERROR, "MonitoringTimerTask.run, bad name: " + name, exc);
                continue;
            }
            if (mBeans == null) continue;
            for (String mBean : mBeans) {
                StringTokenizer st = new StringTokenizer((String)this.attlist.get(name), ",");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (token.equals("*")) {
                        try {
                            List<String> attributes = MXWrapper.getAttributeNames(mBean);
                            if (attributes == null) continue;
                            for (int i = 0; i < attributes.size(); ++i) {
                                String attname = attributes.get(i);
                                try {
                                    this.addRecord(mBean, attname, MXWrapper.getAttribute(mBean, attname));
                                    continue;
                                }
                                catch (Exception exc) {
                                    logger.log(BasicLevel.ERROR, "MonitoringTimerTask.run, bad attribute : " + mBean + ":" + attname, exc);
                                }
                            }
                            continue;
                        }
                        catch (Exception exc) {
                            logger.log(BasicLevel.ERROR, "MonitoringTimerTask.run", exc);
                            continue;
                        }
                    }
                    String attname = token.trim();
                    try {
                        this.addRecord(mBean, attname, MXWrapper.getAttribute(mBean, attname));
                    }
                    catch (Exception exc) {
                        logger.log(BasicLevel.ERROR, "MonitoringTimerTask.run, bad attribute : " + mBean + ":" + attname, exc);
                    }
                }
            }
        }
        this.finalizeRecords();
    }

    @Override
    public String[] getMonitoredAttributes() {
        int i = 0;
        String[] ret = new String[this.attlist.size()];
        Enumeration<Object> e = this.attlist.keys();
        while (e.hasMoreElements()) {
            String mbean = (String)e.nextElement();
            ret[i++] = mbean + '=' + this.attlist.getProperty(mbean);
        }
        return ret;
    }

    @Override
    public void addMonitoredAttributes(String MBeanName, String attributes) {
        this.attlist.put(MBeanName, attributes);
    }

    @Override
    public void delMonitoredAttributes(String MBeanName) {
        this.attlist.remove(MBeanName);
    }

    @Override
    public void cancelTask() {
        this.cancel();
    }
}

