/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.api;

import org.objectweb.util.monolog.api.Level;
import org.objectweb.util.monolog.api.LoggingFactory;

public final class BasicLevel {
    public static int BADLEVEL = 0;
    public static Level FATAL = null;
    public static Level ERROR = null;
    public static Level WARN = null;
    public static Level INFO = null;
    public static Level DEBUG = null;
    private static LoggingFactory factory = null;

    public static void initialize(LoggingFactory f) {
        factory = f;
        FATAL = factory.getFatalLevel();
        ERROR = factory.getErrorLevel();
        WARN = factory.getWarnLevel();
        INFO = factory.getInfoLevel();
        DEBUG = factory.getDebugLevel();
    }

    public static int getIntLevel(String name) {
        if (name.equals("BasicLevel.DEBUG") || name.equals("DEBUG")) {
            return DEBUG.intValue();
        }
        if (name.equals("BasicLevel.ERROR") || name.equals("ERROR")) {
            return ERROR.intValue();
        }
        if (name.equals("BasicLevel.FATAL") || name.equals("FATAL")) {
            return FATAL.intValue();
        }
        if (name.equals("BasicLevel.INFO") || name.equals("INFO")) {
            return INFO.intValue();
        }
        if (name.equals("BasicLevel.WARN") || name.equals("WARN")) {
            return WARN.intValue();
        }
        Level level = factory.parse(name);
        if (level != null) {
            return level.intValue();
        }
        return BADLEVEL;
    }

    public static Level parse(String name) {
        return factory.parse(name);
    }

    public static Level fromIntLevel(int level) {
        if (level == FATAL.intValue()) {
            return FATAL;
        }
        if (level == ERROR.intValue()) {
            return ERROR;
        }
        if (level == WARN.intValue()) {
            return WARN;
        }
        if (level == INFO.intValue()) {
            return INFO;
        }
        if (level == DEBUG.intValue()) {
            return DEBUG;
        }
        return null;
    }

    public static int getIntLevel(Level level) {
        return level.intValue();
    }
}

