/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.common;

import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Level;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggingFactory;

public final class Debug {
    public static final boolean debug = true;
    public static final String DEBUG_DIR_PROPERTY = "fr.dyade.aaa.DEBUG_DIR";
    public static final String DEBUG_FILE_PROPERTY = "fr.dyade.aaa.DEBUG_FILE";
    public static final String DEFAULT_DEBUG_FILE = "a3debug.cfg";
    public static final String DEBUG_LOGGING_FACTORY_PROPERTY = "fr.dyade.aaa.DEBUG_LOGGING_FACTORY";
    public static final String DEFAULT_DEBUG_LOGGING_FACTORY = "org.objectweb.util.monolog.jul.SimpleLoggingFactory";
    private static LoggingFactory factory;

    protected static void init() throws Exception {
        try {
            String lfcn = System.getProperty(DEBUG_LOGGING_FACTORY_PROPERTY, DEFAULT_DEBUG_LOGGING_FACTORY);
            Class<?> fclass = Class.forName(lfcn);
            factory = (LoggingFactory)fclass.newInstance();
            String debugDir = System.getProperty(DEBUG_DIR_PROPERTY);
            String debugFileName = System.getProperty(DEBUG_FILE_PROPERTY, DEFAULT_DEBUG_FILE);
            BasicLevel.initialize(factory);
            factory.initialize(debugDir, debugFileName);
        }
        catch (Exception exc) {
            System.err.println("Monolog configuration file not found, use defaults");
            exc.printStackTrace();
            throw new Exception("Unable to configure monolog wrapper");
        }
    }

    public static Logger getLogger(String topic) {
        try {
            if (factory == null) {
                Debug.init();
            }
            Logger logger = factory.getLogger(topic);
            return logger;
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public static void setLoggerFactory(LoggingFactory loggerFactory) {
    }

    public static void setDebugLevel(String classname) {
        Debug.getLogger(classname).setLevel(BasicLevel.DEBUG);
    }

    public static void setInfoLevel(String classname) {
        Debug.getLogger(classname).setLevel(BasicLevel.INFO);
    }

    public static void setWarnLevel(String classname) {
        Debug.getLogger(classname).setLevel(BasicLevel.WARN);
    }

    public static void setErrorLevel(String classname) {
        Debug.getLogger(classname).setLevel(BasicLevel.ERROR);
    }

    public static void setFatalLevel(String classname) {
        Debug.getLogger(classname).setLevel(BasicLevel.FATAL);
    }

    public static void setLoggerLevel(String classname, String level) throws Exception {
        Debug.getLogger(classname).setLevel(level);
    }

    public static void clearLevel(String classname) {
        Debug.getLogger(classname).setLevel((Level)null);
    }
}

