/*
 * Decompiled with CFR 0.152.
 */
package com.scalagent.jmx;

import fr.dyade.aaa.common.osgi.Activator;
import fr.dyade.aaa.util.management.MXServer;
import fr.dyade.aaa.util.management.MXWrapper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.osgi.framework.ServiceRegistration;

public class JMXServer
implements MXServer {
    public static boolean registerAsService = false;
    private MBeanServer mxserver = null;
    private Map<ObjectName, ServiceRegistration> registeredServices = new HashMap<ObjectName, ServiceRegistration>();

    public JMXServer(MBeanServer mxserver) {
        this.mxserver = mxserver;
    }

    public JMXServer() {
        try {
            Class<?> clazz = Class.forName("java.lang.management.ManagementFactory");
            Method method = clazz.getMethod("getPlatformMBeanServer", null);
            this.mxserver = (MBeanServer)method.invoke(null, (Object[])null);
        }
        catch (Exception exc) {
            this.mxserver = MBeanServerFactory.createMBeanServer("AgentServer");
        }
        MXWrapper.setMXServer(this);
    }

    private void registerOSGi(Object obj, ObjectName objName) {
        if (!registerAsService) {
            return;
        }
        Hashtable<String, String> registrationProperties = objName.getKeyPropertyList();
        registrationProperties.put("domain", objName.getDomain());
        if (this.registeredServices.containsKey(objName)) {
            ServiceRegistration registration = this.registeredServices.get(objName);
            registration.setProperties(registrationProperties);
            return;
        }
        HashSet<String> serviceNames = new HashSet<String>();
        this.computeOSGiServiceNames(obj.getClass(), obj, serviceNames);
        ServiceRegistration registration = Activator.context.registerService(serviceNames.toArray(new String[serviceNames.size()]), obj, registrationProperties);
        this.registeredServices.put(objName, registration);
    }

    private void computeOSGiServiceNames(Class<?> beanClass, Object bean, Set<String> registered) {
        if (beanClass == null) {
            return;
        }
        Class<?>[] interfaces = beanClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].getName().endsWith("MBean") || registered.contains(interfaces[i].getName())) continue;
            registered.add(interfaces[i].getName());
            this.computeOSGiServiceNames(interfaces[i], bean, registered);
        }
        this.computeOSGiServiceNames(beanClass.getSuperclass(), bean, registered);
    }

    @Override
    public synchronized void registerMBean(Object bean, String fullName) throws Exception {
        if (this.mxserver == null) {
            return;
        }
        ObjectName objName = ObjectName.getInstance(fullName);
        this.mxserver.registerMBean(bean, objName);
        this.registerOSGi(bean, objName);
    }

    @Override
    public synchronized void unregisterMBean(String fullName) throws Exception {
        ServiceRegistration registration;
        if (this.mxserver == null) {
            return;
        }
        ObjectName objName = ObjectName.getInstance(fullName);
        this.mxserver.unregisterMBean(objName);
        if (registerAsService && (registration = this.registeredServices.remove(objName)) != null) {
            registration.unregister();
        }
    }

    @Override
    public Object getAttribute(String objectName, String attribute) throws Exception {
        if (this.mxserver == null) {
            return null;
        }
        return this.mxserver.getAttribute(new ObjectName(objectName), attribute);
    }

    @Override
    public List<String> getAttributeNames(String objectName) throws Exception {
        if (this.mxserver == null) {
            return null;
        }
        MBeanAttributeInfo[] attrs = this.mxserver.getMBeanInfo(new ObjectName(objectName)).getAttributes();
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < attrs.length; ++i) {
            names.add(attrs[i].getName());
        }
        return names;
    }

    @Override
    public Set<String> queryNames(String objectName) throws MalformedObjectNameException {
        if (this.mxserver == null) {
            return null;
        }
        Set<ObjectName> objectNames = this.mxserver.queryNames(new ObjectName(objectName), null);
        HashSet<String> names = new HashSet<String>();
        for (ObjectName objName : objectNames) {
            names.add(objName.getCanonicalName());
        }
        return names;
    }
}

