/*
 * Copyright (C) 2002 - 2022 ScalAgent Distributed Technologies
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA.
 *
 * Original developer: ScalAgent Distributed Technologies
 * Contributor(s): Douglas S. Jackson
 */
package fr.dyade.aaa.common;

import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.Level;
import org.objectweb.util.monolog.api.LoggingFactory;

/**
 * This class handles the debug traces.
 */
public final class Debug {
  /** flag used to remove huge logging */
  public final static boolean debug = true;

  /**
   * Property name for A3 debug configuration directory.
   * If not defined, the configuration file is searched from the search path used to load classes.
   */
  public final static String DEBUG_DIR_PROPERTY = "fr.dyade.aaa.DEBUG_DIR";
  /** Property name for A3 debug configuration filename */
  public final static String DEBUG_FILE_PROPERTY = "fr.dyade.aaa.DEBUG_FILE";
  /** Default filename for A3 debug configuration */
  public final static String DEFAULT_DEBUG_FILE = "a3debug.cfg";

  /** Property name for LoggerFactory classname */
  public final static String DEBUG_LOGGING_FACTORY_PROPERTY = "fr.dyade.aaa.DEBUG_LOGGING_FACTORY";
  /** Default LoggerFactory classname */
  public final static String DEFAULT_DEBUG_LOGGING_FACTORY = "org.objectweb.util.monolog.jul.SimpleLoggingFactory";
  
  /** */
  private static LoggingFactory factory;

  protected static void init() throws Exception {
    try {
      // Configures the underlying logging framework.
      String lfcn = System.getProperty(DEBUG_LOGGING_FACTORY_PROPERTY, DEFAULT_DEBUG_LOGGING_FACTORY);
      Class<?> fclass = Class.forName(lfcn);
//      Method m = fclass.getMethod("initialize", (Class<?>[]) null);
//      factory = (LoggingFactory) m.invoke(null, (Object[]) null); 
      factory = (LoggingFactory) fclass.newInstance();

      String debugDir = System.getProperty(Debug.DEBUG_DIR_PROPERTY);
      String debugFileName = System.getProperty(Debug.DEBUG_FILE_PROPERTY, Debug.DEFAULT_DEBUG_FILE);
      
      // Initializes BasicLevel class with Monolog levels.
      BasicLevel.initialize(factory);

      factory.initialize(debugDir, debugFileName);
    } catch(Exception exc) {
      System.err.println("Monolog configuration file not found, use defaults");
      exc.printStackTrace();
//      try {
//        ((MonologFactory) logManager).configure(null);
//        Logger[] loggers = logManager.getLoggers();
//        for (int i=0; i<loggers.length; i++) {
//          loggers[i].setIntLevel(BasicLevel.ERROR);
//        }
//      } catch (Exception e) {
//        System.err.println("Unable to configure monolog wrapper");
//        throw new Exception("Unable to configure monolog wrapper");
//      }
      // TODO:
      throw new Exception("Unable to configure monolog wrapper");
    }
  }

  /**
   * Initializes the package.
   * 
   * @throws Exception fatal error during initialization.
   */
//  private static void initialize() throws Exception {
//    String ldebugDir = debugDir;
//    if (ldebugDir == null)
//      ldebugDir = System.getProperty(DEBUG_DIR_PROPERTY);
//    String ldebugFileName = debugFileName;
//    if (ldebugFileName == null)
//      ldebugFileName = System.getProperty(DEBUG_FILE_PROPERTY, DEFAULT_DEBUG_FILE);
//    if (ldebugDir != null) {
//      File debugFile = new File(ldebugDir, ldebugFileName);
//      try {
//        if (debugFile.exists() && debugFile.isFile() && (debugFile.length() != 0)) {
//          ldebugFileName = debugFile.getPath();
//        } else {
//          throw new IOException();
//        }
//      } catch (IOException exc) {
//        // debug configuration file seems not exist, search it from the
//        // search path used to load classes.
//        System.err.println("Unable to find \"" + debugFile.getPath() + "\".");
//        ldebugDir = null;
//      }
//    }
//
//    try {
////      System.setProperty(org.objectweb.util.monolog.Monolog.MONOLOG_FILE_NAME, ldebugFileName);
////      logManager = org.objectweb.util.monolog.Monolog.initialize();
////      if (logManager == null) {
////        System.err.println("Error in Monolog initialization: null factory");
////      } else {
////        Logger dl = logManager.getLogger("fr.dyade.aaa.util.debug");
////        dl.log(BasicLevel.INFO, "Debug.initialize() - " + ldebugFileName);
////      }
//      // TODO
//      FileInputStream configFile = new FileInputStream(ldebugFileName);
//      LogManager.getLogManager().readConfiguration(configFile);
//    } catch(Throwable exc) {
//      System.err.println("Unable to configure Monolog");
//      exc.printStackTrace();
//      LogManager.getLogManager().readConfiguration();
//    } finally {
//      factory = LogManager.getLogManager();
//      System.err.println("LogManager=" + factory);
//    }
//  }

  public static Logger getLogger(String topic) {
    try {
      if (factory == null) init();
      Logger logger = factory.getLogger(topic);
      return logger;
    } catch (Throwable exc) {
      // TODO
      exc.printStackTrace();
    }
//    if (logger == null)
//      logger = new PrivateLogger();
//    return logger;
    // TODO
    return null;
  }

  /**
   * Set the Monolog Loggerfactory
   * @param loggerFactory the monolog LoggerFactory
   */
  @Deprecated
  public static void setLoggerFactory(LoggingFactory loggerFactory) {
    // TODO (AF): Normally no longer used, to remove in 5.20 release.
//    logManager = loggerFactory;
  }

  public static void setDebugLevel(String classname) {
    getLogger(classname).setLevel(BasicLevel.DEBUG);
  }

  public static void setInfoLevel(String classname) {
    getLogger(classname).setLevel(BasicLevel.INFO);
  }

  public static void setWarnLevel(String classname) {
    getLogger(classname).setLevel(BasicLevel.WARN);
  }

  public static void setErrorLevel(String classname) {
    getLogger(classname).setLevel(BasicLevel.ERROR);
  }

  public static void setFatalLevel(String classname) {
    getLogger(classname).setLevel(BasicLevel.FATAL);
  }
  
  public static void setLoggerLevel(String classname, String level) throws Exception {
    getLogger(classname).setLevel(level);
  }

  public static void clearLevel(String classname) {
    getLogger(classname).setLevel((Level) null);
  }
}
