/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.schema.util;

import java.util.StringTokenizer;
import org.ow2.easywsdl.schema.api.extensions.NamespaceMapperImpl;
import org.ow2.easywsdl.schema.api.extensions.SchemaLocatorImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class EasyXMLFilter
extends XMLFilterImpl {
    private boolean first = true;
    private SchemaLocatorImpl schemaLocator = new SchemaLocatorImpl();
    private NamespaceMapperImpl namespaceContext = new NamespaceMapperImpl();

    public EasyXMLFilter(XMLReader parent) {
        super(parent);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        if (this.first) {
            String schemaLocation = atts.getValue("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
            if (schemaLocation != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(schemaLocation);
                while (stringTokenizer.hasMoreTokens()) {
                    String schemaUri = stringTokenizer.nextToken();
                    if (!stringTokenizer.hasMoreTokens()) continue;
                    String location = stringTokenizer.nextToken();
                    this.schemaLocator.addSchemaLocation(schemaUri, location);
                }
            }
            this.first = false;
        }
        super.startElement(uri, localName, name, atts);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaceContext.addNamespace(prefix, uri);
        super.startPrefixMapping(prefix, uri);
    }

    @Override
    public void startDocument() throws SAXException {
        this.first = true;
        super.startDocument();
    }

    public SchemaLocatorImpl getSchemaLocator() {
        return this.schemaLocator;
    }

    public NamespaceMapperImpl getNamespaceMapper() {
        return this.namespaceContext;
    }
}

