/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.schema;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.ow2.easywsdl.schema.DefaultSchema;
import org.ow2.easywsdl.schema.api.Attribute;
import org.ow2.easywsdl.schema.api.Documentation;
import org.ow2.easywsdl.schema.api.Element;
import org.ow2.easywsdl.schema.api.Import;
import org.ow2.easywsdl.schema.api.Include;
import org.ow2.easywsdl.schema.api.Redefine;
import org.ow2.easywsdl.schema.api.Schema;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.Type;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.api.extensions.NamespaceMapperImpl;
import org.ow2.easywsdl.schema.impl.SchemaJAXBContext;
import org.ow2.easywsdl.schema.impl.SchemaReaderImpl;
import org.ow2.easywsdl.schema.org.w3._2001.xmlschema.FormChoice;

public final class DefaultSchemaImpl
implements DefaultSchema {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(DefaultSchemaImpl.class.getName());
    private final Schema defaultSchema;
    private static final DefaultSchemaImpl INSTANCE;

    private DefaultSchemaImpl(Schema defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    public static DefaultSchema getInstance() {
        return INSTANCE;
    }

    @Override
    public Type getTypeInt() {
        return this.getType(new QName("http://www.w3.org/2001/XMLSchema", "int"));
    }

    @Override
    public Type getTypeString() {
        return this.getType(new QName("http://www.w3.org/2001/XMLSchema", "string"));
    }

    @Override
    public Type getTypeDateTime() {
        return this.getType(new QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
    }

    @Override
    public Type getTypeBoolean() {
        return this.getType(new QName("http://www.w3.org/2001/XMLSchema", "boolean"));
    }

    @Override
    public List<Type> getTypes() {
        List res = null;
        if (this.defaultSchema != null) {
            res = this.defaultSchema.getTypes();
        }
        return res;
    }

    @Override
    public Type getType(QName type) {
        Type res = null;
        for (Type t : this.getTypes()) {
            if (!t.getQName().getNamespaceURI().equals(type.getNamespaceURI()) || !t.getQName().getLocalPart().equals(type.getLocalPart())) continue;
            res = t;
            break;
        }
        return res;
    }

    @Override
    public Type getTypeDouble() {
        return this.getType(new QName("http://www.w3.org/2001/XMLSchema", "double"));
    }

    @Override
    public Type getTypeDuration() {
        return this.getType(new QName("http://www.w3.org/2001/XMLSchema", "duration"));
    }

    @Override
    public Type getTypeFloat() {
        return this.getType(new QName("http://www.w3.org/2001/XMLSchema", "float"));
    }

    @Override
    public Type getTypeInteger() {
        return this.getType(new QName("http://www.w3.org/2001/XMLSchema", "integer"));
    }

    @Override
    public Type getTypeLong() {
        return this.getType(new QName("http://www.w3.org/2001/XMLSchema", "long"));
    }

    @Override
    public Type getTypeShort() {
        return this.getType(new QName("http://www.w3.org/2001/XMLSchema", "short"));
    }

    @Override
    public void addAttribute(Attribute attr) {
        this.defaultSchema.addAttribute(attr);
    }

    @Override
    public void addElement(Element elmt) {
        this.defaultSchema.addElement(elmt);
    }

    @Override
    public void addImport(Import importDef) {
        this.defaultSchema.addImport(importDef);
    }

    @Override
    public void addInclude(Include includeDef) throws SchemaException {
        this.defaultSchema.addInclude(includeDef);
    }

    @Override
    public void addRedefine(Redefine redefineDef) {
        this.defaultSchema.addRedefine(redefineDef);
    }

    @Override
    public void addType(Type absItfType) {
        this.defaultSchema.addType(absItfType);
    }

    @Override
    public Attribute createAttribute() {
        return (Attribute)this.defaultSchema.createAttribute();
    }

    @Override
    public Type createComplexType() {
        return (Type)this.defaultSchema.createComplexType();
    }

    @Override
    public Element createElement() {
        return (Element)this.defaultSchema.createElement();
    }

    @Override
    public Import createImport() throws SchemaException {
        return (Import)this.defaultSchema.createImport();
    }

    @Override
    public Include createInclude() throws SchemaException {
        return (Include)this.defaultSchema.createInclude();
    }

    @Override
    public Redefine createRedefine() throws SchemaException {
        return (Redefine)this.defaultSchema.createRedefine();
    }

    @Override
    public Type createSimpleType() {
        return (Type)this.defaultSchema.createSimpleType();
    }

    @Override
    public List<Element> findElementsInAllSchema(QName element) {
        return this.defaultSchema.findElementsInAllSchema(element);
    }

    @Override
    public NamespaceMapperImpl getAllNamespaces() {
        return this.defaultSchema.getAllNamespaces();
    }

    @Override
    public Attribute getAttribute(QName attr) {
        return (Attribute)this.defaultSchema.getAttribute(attr);
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.defaultSchema.getAttributes();
    }

    @Override
    public List<String> getBlockDefault() {
        return this.defaultSchema.getBlockDefault();
    }

    @Override
    public URI getDocumentURI() {
        return this.defaultSchema.getDocumentURI();
    }

    @Override
    public Element getElement(QName element) {
        return (Element)this.defaultSchema.getElement(element);
    }

    @Override
    public List<Element> getElements() {
        return this.defaultSchema.getElements();
    }

    @Override
    public List<String> getFinalDefault() {
        return this.defaultSchema.getFinalDefault();
    }

    @Override
    public List<Import> getImports(String namespaceURI) {
        return this.defaultSchema.getImports(namespaceURI);
    }

    @Override
    public List<Import> getImports() {
        return this.defaultSchema.getImports();
    }

    @Override
    public List<Include> getIncludes(URI locationURI) throws URISyntaxException {
        return this.defaultSchema.getIncludes(locationURI);
    }

    @Override
    public List<Include> getIncludes() {
        return this.defaultSchema.getIncludes();
    }

    @Override
    public List<Redefine> getRedefines(String namespaceURI) {
        return this.defaultSchema.getRedefines(namespaceURI);
    }

    @Override
    public List<Redefine> getRedefines() {
        return this.defaultSchema.getRedefines();
    }

    @Override
    public String getLang() {
        return this.defaultSchema.getLang();
    }

    @Override
    public String getTargetNamespace() {
        return this.defaultSchema.getTargetNamespace();
    }

    @Override
    public String getVersion() {
        return this.defaultSchema.getVersion();
    }

    @Override
    public Import removeImport(Import importDef) {
        return this.defaultSchema.removeImport(importDef);
    }

    @Override
    public Include removeInclude(Include includeDef) throws SchemaException {
        return this.defaultSchema.removeInclude(includeDef);
    }

    @Override
    public Redefine removeRedefine(Redefine redefineDef) {
        return this.defaultSchema.removeRedefine(redefineDef);
    }

    @Override
    public void setDocumentURI(URI documentBaseURI) {
        this.defaultSchema.setDocumentURI(documentBaseURI);
    }

    @Override
    public void setTargetNamespace(String tns) {
        this.defaultSchema.setTargetNamespace(tns);
    }

    @Override
    public Map<QName, String> getOtherAttributes() throws XmlException {
        return this.defaultSchema.getOtherAttributes();
    }

    @Override
    public void setDocumentation(Documentation doc) {
        this.defaultSchema.setDocumentation(doc);
    }

    @Override
    public FormChoice getAttributeFormDefault() {
        return this.defaultSchema.getAttributeFormDefault();
    }

    @Override
    public FormChoice getElementFormDefault() {
        return this.defaultSchema.getElementFormDefault();
    }

    @Override
    public void setAttributeFormDefault(FormChoice form) {
        this.defaultSchema.setAttributeFormDefault(form);
    }

    @Override
    public void setElementFormDefault(FormChoice form) {
        this.defaultSchema.setElementFormDefault(form);
    }

    @Override
    public Documentation createDocumentation() {
        return this.defaultSchema.createDocumentation();
    }

    @Override
    public Documentation getDocumentation() {
        return this.defaultSchema.getDocumentation();
    }

    static {
        URL schemaUrl = SchemaJAXBContext.class.getResource("/org/ow2/easywsdl/schema/XMLSchema.xsd");
        Schema defaultSchema = null;
        try {
            defaultSchema = new SchemaReaderImpl().read(schemaUrl);
        }
        catch (XmlException e) {
            e.printStackTrace();
            LOG.warning("Error to read default parent => " + e.getMessage());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            LOG.warning("Error to read default parent => " + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.warning("I/O error reading " + schemaUrl.toString() + " : " + e.getMessage());
        }
        INSTANCE = new DefaultSchemaImpl(defaultSchema);
    }
}

