/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.xml;

import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class QNameHelper {
    private QNameHelper() {
    }

    public static String getPrefix(String name) {
        String res = null;
        if (name != null && name.indexOf(58) != -1) {
            res = name.substring(0, name.indexOf(58));
        }
        return res;
    }

    public static String getLocalPartWithoutPrefix(String name) {
        String res = name;
        if (name.indexOf(58) != -1) {
            res = name.substring(name.indexOf(58) + 1, name.length());
        }
        return res;
    }

    public static final QName fromString(Node container, String text, String defaultNs) {
        String namespaceURI;
        String localName;
        assert (container != null);
        assert (text != null);
        if (text.trim().isEmpty()) {
            return new QName("");
        }
        String[] texts = text.split(":");
        int size = texts.length;
        if (size == 1) {
            localName = texts[0];
            namespaceURI = defaultNs;
        } else if (size == 2) {
            namespaceURI = container.lookupNamespaceURI(texts[0]);
            localName = texts[1];
        } else {
            throw new IllegalArgumentException("Invalid QName string '" + text + "'");
        }
        return new QName(namespaceURI, localName);
    }

    public static final QName fromString(Node container, String text) {
        assert (container != null);
        assert (text != null);
        return QNameHelper.fromString(container, text, container.getNamespaceURI());
    }

    public static final QName fromString(Node node) {
        assert (node != null);
        String textContent = node.getTextContent();
        return QNameHelper.fromString(node, textContent);
    }

    public static final QName fromAttribute(Element element, String attributeName) {
        assert (element != null);
        assert (attributeName != null);
        return QNameHelper.fromString(element, element.getAttribute(attributeName));
    }
}

