/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.xml;

import com.ebmwebsourcing.easycommons.pooling.GenericResourcePool;
import com.ebmwebsourcing.easycommons.pooling.PoolException;
import com.ebmwebsourcing.easycommons.pooling.PoolPolicy;
import com.ebmwebsourcing.easycommons.pooling.ResourceHandler;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

public class DocumentBuilderResourcePool {
    private final GenericResourcePool<DocumentBuilder> documentBuilderResourcePool;

    public DocumentBuilderResourcePool(int minPoolSize, int maxPoolSize, PoolPolicy poolPolicy) {
        DocumentBuilderResourceHandler documentBuilderResourceHandler = new DocumentBuilderResourceHandler();
        this.documentBuilderResourcePool = new GenericResourcePool<DocumentBuilder>(documentBuilderResourceHandler, minPoolSize, maxPoolSize, poolPolicy);
    }

    public DocumentBuilder take() {
        return this.documentBuilderResourcePool.take();
    }

    public final void release(DocumentBuilder documentBuilder) {
        this.documentBuilderResourcePool.release(documentBuilder);
    }

    private static class DocumentBuilderResourceHandler
    implements ResourceHandler<DocumentBuilder> {
        final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();

        public DocumentBuilderResourceHandler() {
            this.documentBuilderFactory.setNamespaceAware(true);
        }

        @Override
        public DocumentBuilder create() {
            try {
                return this.documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new PoolException(e);
            }
        }

        @Override
        public void onRelease(DocumentBuilder documentBuilder) {
            documentBuilder.reset();
        }

        @Override
        public void onTake(DocumentBuilder documentBuilder) {
        }
    }
}

