/**
 * Copyright (c) 2010-2012 EBM WebSourcing, 2012-2023 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the New BSD License (3-clause license).
 *
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the New BSD License (3-clause license)
 * for more details.
 *
 * You should have received a copy of the New BSD License (3-clause license)
 * along with this program/library; If not, see http://directory.fsf.org/wiki/License:BSD_3Clause/
 * for the New BSD License (3-clause license).
 */
package com.ebmwebsourcing.easycommons.lang;

/**
 * @author Mathieu CARROLLE - EBM WebSourcing
 */
public class StringHelper {

    /**
     * Return true if the String is null, contains only space character or is
     * empty.
     * 
     * @param s
     *            a string
     * 
     * @return true if the String is null, contains only space character or is
     *         empty, otherwise false
     */
    public static boolean isNullOrEmpty(final String s) {
        return (s == null) || s.trim().isEmpty();
    }
    
    /**
     * Return an empty {@link String} if <b>obj</b> is null, otherwise
     * return obj.toString().
     * 
     * @param obj
     * @return
     */
    public static String nonNullValue(Object obj) {
        if (obj == null)
            return "";
        return obj.toString();
    }
    
    /**
     * Test the equality of the specified strings. test is : ( (a==b==null) ||
     * a.equals(b) )
     * 
     * @param a
     * @param b
     * @return
     */
    public static final boolean equal(final String a, final String b) {
        boolean result;
        if (a == null) {
            result = b == null;
        } else {
            result = a.equals(b);
        }
        return result;
    }
}
