/**
 * Copyright (c) 2010-2012 EBM WebSourcing, 2012-2023 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the New BSD License (3-clause license).
 *
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the New BSD License (3-clause license)
 * for more details.
 *
 * You should have received a copy of the New BSD License (3-clause license)
 * along with this program/library; If not, see http://directory.fsf.org/wiki/License:BSD_3Clause/
 * for the New BSD License (3-clause license).
 */
package com.ebmwebsourcing.easycommons.lang;

import java.io.PrintWriter;
import java.io.StringWriter;

/**
 * @author Adrien Ruffie - EBM WebSourcing
 */
public final class ExceptionHelper {

    private ExceptionHelper() {      
    }
    
    public static final String getMessageFromRootCause(final Throwable exception) {
        assert exception != null;
        
        final Throwable cause = exception.getCause();
        if(cause == null) {
            return exception.getMessage();
        } else {
            return getMessageFromRootCause(cause);
        }
    }

    /**
     * Return the stacktrace as a string
     * 
     * @param throwable
     * @return
     */
    public static final String getStackTrace(final Throwable throwable) {
        assert throwable != null;

        final StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        sw.flush();
        return sw.toString();
    }
}
