/**
 * Copyright (c) 2010-2012 EBM WebSourcing, 2012-2023 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the New BSD License (3-clause license).
 *
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the New BSD License (3-clause license)
 * for more details.
 *
 * You should have received a copy of the New BSD License (3-clause license)
 * along with this program/library; If not, see http://directory.fsf.org/wiki/License:BSD_3Clause/
 * for the New BSD License (3-clause license).
 */
package com.ebmwebsourcing.easycommons.lang;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/**
 * 
 * @author "Mathieu CARROLLE - EBM WebSourcing"
 * 
 */
public class CollectionHelper {

    public interface Filter<T> {
        boolean accept(T item);
    }

    /**
     * Remove object from the specified List according to Filter. Filter are
     * exclusively applied.
     * 
     * @param target
     * @param filters
     */
    public static <T> void filter(Collection<T> target, List<Filter<T>> filters) {
        Iterator<T> it = target.iterator();
        while (it.hasNext()) {
            T item = it.next();
            for (Filter<T> filter : filters) {
                if (!filter.accept(item)) {
                    it.remove();
                    break;
                }
            }
        }
    }

}
