/**
 * Copyright (c) 2010-2012 EBM WebSourcing, 2012-2023 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the New BSD License (3-clause license).
 *
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the New BSD License (3-clause license)
 * for more details.
 *
 * You should have received a copy of the New BSD License (3-clause license)
 * along with this program/library; If not, see http://directory.fsf.org/wiki/License:BSD_3Clause/
 * for the New BSD License (3-clause license).
 */
package com.ebmwebsourcing.easycommons.lang;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Adrien Ruffie - EBM WebSourcing
 */
public final class ArrayHelper {

    private ArrayHelper() {
    }

    
    @SuppressWarnings("unchecked")
    public static <T> T[] mergeArrays(T[]... arrays) {
        assert arrays != null;
        assert arrays.length > 0;
        int totalLength = 0;
        for (T[] array : arrays) {
            totalLength += array.length;
        }
        T[] merged = (T[]) Array.newInstance(arrays[0].getClass().getComponentType(), 
                totalLength);
        int destPos = 0;
        for (T[] array : arrays) {
            System.arraycopy(array, 0, merged, destPos, array.length);
            destPos += array.length;
        }
        return merged;
    }


    @SuppressWarnings("unchecked")
    public static <T> T[] arrayRemove(T[] array, T... toRemoveObjects) {
        List<T> result = new ArrayList<T>();
        for (T object : array) {
            if (arrayContainsSameObject(toRemoveObjects, object)) continue;
            result.add(object);
        }
        return result.toArray((T[]) Array.newInstance(array.getClass().getComponentType(), result.size()));        
    }
    
    
    public static <T> boolean arrayContainsSameObject(T[] array, T sameObject) {
        for (T object : array) {
            if (object == sameObject) return true;
        }
        return false;
    }
      
    
    
}
