/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.vdsm.jsonrpc.client.utils.retry;

import java.util.concurrent.Callable;
import org.ovirt.vdsm.jsonrpc.client.internal.ClientPolicy;
import org.ovirt.vdsm.jsonrpc.client.utils.retry.RetryContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Retryable<T>
implements Callable<T> {
    private static Logger log = LoggerFactory.getLogger(Retryable.class);
    private Callable<T> callable;
    private RetryContext context;

    public Retryable(Callable<T> callable, ClientPolicy policy) {
        this.callable = callable;
        this.context = new RetryContext(policy);
    }

    @Override
    public T call() throws Exception {
        while (true) {
            try {
                return this.callable.call();
            }
            catch (Exception e) {
                log.warn("Retry failed");
                if (log.isDebugEnabled()) {
                    log.debug(e.getMessage(), (Throwable)e);
                }
                if (this.context.isExceptionRetryable(e)) {
                    this.context.decreaseAttempts();
                    if (this.context.getNumberOfAttempts() <= 0) {
                        throw e;
                    }
                    this.context.waitOperation();
                    continue;
                }
                throw e;
            }
            break;
        }
    }
}

