/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.vdsm.jsonrpc.client.utils;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.ovirt.vdsm.jsonrpc.client.JsonRpcRequest;
import org.ovirt.vdsm.jsonrpc.client.JsonRpcResponse;
import org.ovirt.vdsm.jsonrpc.client.ResponseBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    public static final Charset UTF8 = StandardCharsets.UTF_8;
    private static final double GRACE_PERIOD = 0.5;
    public static final String ALL = "*";
    public static final String SUBSCRIPTION_ALL = "*|*|*|*";
    private static Logger log = LoggerFactory.getLogger(JsonUtils.class);
    private static ObjectMapper mapper = new ObjectMapper();
    private static JsonFactory factory = mapper.getFactory();

    public static Map<String, Object> mapValues(JsonNode node) {
        Map map = null;
        try {
            map = (Map)mapper.readValue(mapper.writeValueAsBytes((Object)node), (TypeReference)new TypeReference<HashMap<String, Object>>(){});
        }
        catch (IOException e) {
            log.debug("Exception thrown during marshalling json", (Throwable)e);
        }
        return map;
    }

    public static byte[] jsonToByteArray(JsonNode json) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (JsonGenerator gen = factory.createGenerator((OutputStream)os, JsonEncoding.UTF8);){
            gen.writeTree((TreeNode)json);
        }
        catch (IOException e) {
            log.debug("Exception thrown during marshalling json", (Throwable)e);
        }
        return os.toByteArray();
    }

    public static byte[] jsonToByteArray(List<JsonRpcRequest> requests) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (JsonGenerator gen = factory.createGenerator((OutputStream)os, JsonEncoding.UTF8);){
            gen.writeStartArray();
            for (JsonRpcRequest request : requests) {
                gen.writeTree((TreeNode)request.toJson());
            }
            gen.writeEndArray();
        }
        catch (IOException e) {
            log.debug("Exception thrown during marshalling json", (Throwable)e);
        }
        return os.toByteArray();
    }

    public static <T> JsonRpcResponse buildErrorResponse(JsonNode id, T code, String message) {
        HashMap<String, Object> error = new HashMap<String, Object>();
        error.put("code", code);
        error.put("message", message);
        return new ResponseBuilder(id).withError(error).build();
    }

    public static JsonRpcResponse buildFailedResponse(JsonRpcRequest request) {
        return JsonUtils.buildErrorResponse(request.getId(), 5022, "Message timeout which can be caused by communication issues");
    }

    public static String getAddress(String host, int port) {
        return host + ":" + port;
    }

    public static ByteBuffer cloneBuffer(ByteBuffer original) {
        int pos = original.position();
        original.clear();
        ByteBuffer clone = ByteBuffer.allocate(original.capacity());
        clone.put(original);
        clone.flip();
        clone.position(pos);
        return clone;
    }

    public static boolean isEmpty(String value) {
        return value == null || "".equals(value.trim());
    }

    public static int reduceGracePeriod(int interval) {
        return interval - (int)((double)interval * 0.5);
    }

    public static int addGracePeriod(int interval) {
        return interval + (int)((double)interval * 0.5);
    }

    public static String swapHeartbeat(String heartbeat) {
        String[] heartbeats = heartbeat.split(",");
        return heartbeats[1] + "," + heartbeats[0];
    }

    public static long getTimeout(int timeout, TimeUnit unit) {
        return Clock.systemUTC().millis() + TimeUnit.MILLISECONDS.convert(timeout, unit);
    }

    public static void logException(Logger logger, String message, Throwable throwable) {
        if (logger.isDebugEnabled()) {
            logger.debug(message, throwable);
        } else {
            logger.error(message);
        }
    }

    public static String[] parse(String id) {
        String[] ids = id.split("\\|");
        if (ids.length != 4) {
            throw new IllegalArgumentException("wrong id format");
        }
        return ids;
    }

    static {
        mapper.configure(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY, true);
    }
}

