/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.vdsm.jsonrpc.client.utils;

import java.util.HashMap;
import java.util.Map;
import org.ovirt.vdsm.jsonrpc.client.JsonRpcResponse;
import org.ovirt.vdsm.jsonrpc.client.ResponseDecomposer;

public class JsonResponseUtil {
    private static final String STATUS = "status";
    private static final String DEFAULT_KEY = "info";
    private static final Map<String, Object> STATUS_DONE = new HashMap<String, Object>(){
        {
            super.put("code", 0);
        }
    };
    private static final Map<String, Object> TIMEOUT_STATUS = new HashMap<String, Object>(){
        {
            super.put("code", -1);
        }
    };
    private Map<String, Object> responseMap = new HashMap<String, Object>();
    private String responseKey;
    private String subtypeKey;
    private Class<?> clazz = STATUS_DONE.getClass();
    private Class<?> subTypeClazz;
    private boolean ignoreResponseKey;

    public Map<String, Object> populate(JsonRpcResponse response) {
        ResponseDecomposer decomposer = new ResponseDecomposer(response);
        if (decomposer.isError()) {
            this.responseMap = decomposer.decomposeError();
        } else if (Object[].class.equals(this.clazz) && this.subtypeKey != null && !this.subtypeKey.trim().isEmpty() && this.subTypeClazz != null) {
            Object[] array = (Object[])decomposer.decomposeResponse(this.clazz);
            this.updateResponse(decomposer.decomposeTypedArray(array, this.subTypeClazz, this.subtypeKey));
        } else {
            this.updateResponse(decomposer.decomposeResponse(this.clazz));
        }
        this.checkAndUpdateStatus();
        return this.responseMap;
    }

    private void updateResponse(Object object) {
        if (this.ignoreResponseKey) {
            this.responseMap = (Map)object;
        } else {
            String key = DEFAULT_KEY;
            if (this.responseKey != null && !this.responseKey.trim().isEmpty()) {
                key = this.responseKey;
            }
            this.responseMap.put(key, object);
        }
    }

    private void checkAndUpdateStatus() {
        this.responseMap.putIfAbsent(STATUS, STATUS_DONE);
    }

    public JsonResponseUtil withResponseKey(String responseKey) {
        this.responseKey = responseKey;
        return this;
    }

    public JsonResponseUtil withResponseType(Class<?> clazz) {
        this.clazz = clazz;
        return this;
    }

    public JsonResponseUtil withIgnoreResponseKey() {
        this.ignoreResponseKey = true;
        return this;
    }

    public JsonResponseUtil withSubtypeKey(String subTypeKey) {
        this.subtypeKey = subTypeKey;
        return this;
    }

    public JsonResponseUtil withSubTypeClazz(Class<?> clazz) {
        this.subTypeClazz = clazz;
        return this;
    }
}

