/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.vdsm.jsonrpc.client.reactors.stomp;

import java.nio.channels.Selector;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import org.ovirt.vdsm.jsonrpc.client.ClientConnectionException;
import org.ovirt.vdsm.jsonrpc.client.reactors.PlainClient;
import org.ovirt.vdsm.jsonrpc.client.reactors.Reactor;
import org.ovirt.vdsm.jsonrpc.client.reactors.stomp.impl.Message;
import org.ovirt.vdsm.jsonrpc.client.utils.JsonUtils;
import org.ovirt.vdsm.jsonrpc.client.utils.OneTimeCallback;
import org.ovirt.vdsm.jsonrpc.client.utils.retry.AwaitRetry;

public class StompClient
extends PlainClient {
    private OneTimeCallback callback = new OneTimeCallback(){

        @Override
        public void execute() throws ClientConnectionException {
            StompClient.this.connected = new CountDownLatch(1);
            StompClient.this.subscribed = new CountDownLatch(1);
            this.subscribe(StompClient.this.getResponseQueue());
            String eventQueue = StompClient.this.getEventQueue();
            if (!JsonUtils.isEmpty(eventQueue)) {
                this.subscribe(eventQueue);
            }
            Message message = new Message().connect().withHeader("accept-version", "1.2").withHeader("host", StompClient.this.policy.getIdentifier());
            int outgoing = 0;
            int incoming = 0;
            if (StompClient.this.policy.isIncomingHeartbeat()) {
                incoming = StompClient.this.policy.getIncomingHeartbeat();
            }
            if (StompClient.this.policy.isOutgoingHeartbeat()) {
                outgoing = StompClient.this.policy.getOutgoingHeartbeat();
            }
            if (incoming != 0 || outgoing != 0) {
                message.withHeader("heart-beat", outgoing + "," + JsonUtils.reduceGracePeriod(incoming));
            }
            StompClient.this.sendNow(message.build());
            try {
                AwaitRetry.retry(() -> {
                    StompClient.this.connected.await(StompClient.this.policy.getRetryTimeOut(), StompClient.this.policy.getTimeUnit());
                    return null;
                });
            }
            catch (Exception e) {
                StompClient.this.disconnect("Waiting for connect interrupted");
                throw new ClientConnectionException("Timeout during connection", e);
            }
        }

        private void subscribe(String queueName) {
            String subId = UUID.randomUUID().toString();
            StompClient.this.subscriptionIds.add(subId);
            StompClient.this.sendNow(new Message().subscribe().withHeader("destination", queueName).withHeader("id", subId).withHeader("ack", "auto").build());
        }
    };

    public StompClient(Reactor reactor, Selector selector, String hostname, int port) {
        super(reactor, selector, hostname, port);
    }

    @Override
    public void sendMessage(byte[] message) {
        this.send(new Message().send().withHeader("destination", this.getRequestQueue()).withHeader("reply-to", this.getResponseQueue()).withCorrelationId().withContent(message).build());
    }

    @Override
    protected void postConnect(OneTimeCallback callback) throws ClientConnectionException {
        super.postConnect(callback);
        callback.execute();
    }

    @Override
    protected OneTimeCallback getPostConnectCallback() {
        this.callback.resetExecution();
        return this.callback;
    }

    @Override
    public boolean isInInit() {
        return false;
    }
}

