/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.vdsm.jsonrpc.client.reactors;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.ovirt.vdsm.jsonrpc.client.ClientConnectionException;
import org.ovirt.vdsm.jsonrpc.client.reactors.Reactor;
import org.ovirt.vdsm.jsonrpc.client.reactors.ReactorClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReactorListener {
    private static Logger log = LoggerFactory.getLogger(ReactorListener.class);
    private final EventListener eventListener;
    private final ServerSocketChannel channel;
    private final Reactor reactor;
    private final Selector selector;

    public ReactorListener(Reactor reactor, InetSocketAddress address, Selector selector, EventListener eventListener) throws IOException {
        this.eventListener = eventListener;
        this.reactor = reactor;
        this.selector = selector;
        this.channel = this.setupChannel(address);
    }

    private ServerSocketChannel setupChannel(InetSocketAddress address) throws IOException {
        ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
        serverSocketChannel.configureBlocking(false);
        try {
            serverSocketChannel.register(this.selector, 16, this);
            log.debug("Binding to {}", (Object)address);
            serverSocketChannel.bind(address);
        }
        catch (ClosedChannelException e) {
            log.debug("Connection closed unexpectedly", (Throwable)e);
            throw new RuntimeException("Connection closed unexpectedly", e);
        }
        catch (IOException e) {
            log.debug("Error while setting up channel", (Throwable)e);
            try {
                serverSocketChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
        return serverSocketChannel;
    }

    public int getPort() {
        return this.channel.socket().getLocalPort();
    }

    public ReactorClient accept() {
        ReactorClient client = null;
        try {
            SocketChannel conn = this.channel.accept();
            if (conn == null) {
                return null;
            }
            conn.configureBlocking(false);
            InetSocketAddress address = (InetSocketAddress)conn.getRemoteAddress();
            client = this.reactor.createConnectedClient(this.reactor, this.selector, address.getHostName(), address.getPort(), conn);
            this.eventListener.onAccept(client);
        }
        catch (IOException | ClientConnectionException e) {
            log.error("Not able to accept connection", (Throwable)e);
        }
        return client;
    }

    public Future<Void> close() {
        FutureTask<Void> task = new FutureTask<Void>(() -> {
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        });
        this.reactor.queueFuture(task);
        return task;
    }

    public static interface EventListener
    extends java.util.EventListener {
        public void onAccept(ReactorClient var1);
    }
}

