/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.vdsm.jsonrpc.client.reactors;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.ovirt.vdsm.jsonrpc.client.ClientConnectionException;
import org.ovirt.vdsm.jsonrpc.client.reactors.Reactor;
import org.ovirt.vdsm.jsonrpc.client.reactors.stomp.StompCommonClient;
import org.ovirt.vdsm.jsonrpc.client.utils.OneTimeCallback;
import org.ovirt.vdsm.jsonrpc.client.utils.retry.Retryable;

public abstract class PlainClient
extends StompCommonClient {
    protected final Selector selector;

    public PlainClient(Reactor reactor, Selector selector, String hostname, int port) {
        super(reactor, hostname, port);
        this.selector = selector;
    }

    public PlainClient(Reactor reactor, Selector selector, String hostname, int port, SocketChannel socketChannel) throws ClientConnectionException {
        super(reactor, hostname, port);
        this.selector = selector;
        this.channel = socketChannel;
        this.postConnect(this.getPostConnectCallback());
    }

    @Override
    public void updateInterestedOps() {
        if (this.outbox.isEmpty()) {
            this.getSelectionKey().interestOps(1);
        } else {
            this.getSelectionKey().interestOps(5);
        }
    }

    @Override
    protected int read(ByteBuffer buff) throws IOException {
        return this.channel.read(buff);
    }

    @Override
    protected void write(ByteBuffer buff) throws IOException {
        this.channel.write(buff);
    }

    @Override
    protected void postConnect(OneTimeCallback callback) throws ClientConnectionException {
        try {
            PlainClient client = this;
            FutureTask<SelectionKey> task = this.scheduleTask(new Retryable<SelectionKey>(() -> {
                if (!this.isOpen()) {
                    throw new ClosedChannelException();
                }
                return this.channel.register(this.selector, 1, client);
            }, this.policy));
            this.key = task.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new ClientConnectionException(e);
        }
        if (this.key == null) {
            throw new ClientConnectionException("Connection issue during post connect");
        }
    }

    @Override
    public void postDisconnect() {
    }
}

