/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.vdsm.jsonrpc.client.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.LongUnaryOperator;
import java.util.stream.Collectors;
import org.ovirt.vdsm.jsonrpc.client.JsonRpcEvent;
import org.ovirt.vdsm.jsonrpc.client.events.EventSubscriber;
import org.ovirt.vdsm.jsonrpc.client.utils.JsonUtils;
import org.ovirt.vdsm.jsonrpc.client.utils.LockWrapper;

public class SubscriptionHolder {
    public static final LongUnaryOperator DECREMENT_ONLY_POSITIVE = currentValue -> {
        if (currentValue > 0L) {
            return currentValue - 1L;
        }
        return 0L;
    };
    private final EventSubscriber subscriber;
    private final Deque<JsonRpcEvent> events;
    private final AtomicLong count;
    private final String[] parsedId;
    private List<String> filteredId;
    private final Lock lock;

    public SubscriptionHolder(EventSubscriber subscriber) {
        this.subscriber = subscriber;
        this.count = new AtomicLong();
        this.events = new ConcurrentLinkedDeque<JsonRpcEvent>();
        this.parsedId = JsonUtils.parse(this.getId());
        this.lock = new ReentrantLock();
        this.filter();
    }

    public String getId() {
        return this.subscriber.getSubscriptionId();
    }

    public String[] getParsedId() {
        return this.parsedId;
    }

    private void filter() {
        String[] ids = this.getParsedId();
        this.filteredId = Arrays.stream(ids).filter(id -> !"*".equals(id)).collect(Collectors.toList());
    }

    public List<String> getFilteredId() {
        return new ArrayList<String>(this.filteredId);
    }

    public boolean canProcess() {
        return this.count.get() > 0L;
    }

    public JsonRpcEvent canProcessMore() {
        try (LockWrapper ignored = new LockWrapper(this.lock);){
            if (!this.events.isEmpty() && this.count.getAndUpdate(DECREMENT_ONLY_POSITIVE) > 0L) {
                JsonRpcEvent jsonRpcEvent = this.events.removeLast();
                return jsonRpcEvent;
            }
            JsonRpcEvent jsonRpcEvent = null;
            return jsonRpcEvent;
        }
    }

    public void putEvent(JsonRpcEvent event) {
        try (LockWrapper ignored = new LockWrapper(this.lock);){
            event.setArrivalTime(System.nanoTime());
            this.events.addFirst(event);
        }
    }

    public int getNumberOfEvents() {
        try (LockWrapper ignored = new LockWrapper(this.lock);){
            int n = this.events.size();
            return n;
        }
    }

    public void purgeOldEventsIfNotConsumed(int eventTimeoutInHours) {
        try (LockWrapper ignored = new LockWrapper(this.lock);){
            long threshold = System.nanoTime() - TimeUnit.HOURS.toNanos(eventTimeoutInHours);
            while (!this.events.isEmpty() && this.events.peekLast().getArrivalTime() < threshold) {
                this.events.removeLast();
            }
        }
    }

    public EventSubscriber getSubscriber() {
        return this.subscriber;
    }

    public void clean() {
        try (LockWrapper ignored = new LockWrapper(this.lock);){
            this.events.clear();
        }
    }

    public long incrementCount(long n) {
        return this.count.addAndGet(n);
    }
}

