/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.vdsm.jsonrpc.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.ovirt.vdsm.jsonrpc.client.JsonRpcResponse;
import org.ovirt.vdsm.jsonrpc.client.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseDecomposer {
    private static Logger log = LoggerFactory.getLogger(ResponseDecomposer.class);
    private static ObjectMapper mapper = new ObjectMapper();
    private JsonRpcResponse response;

    public ResponseDecomposer(JsonRpcResponse response) {
        this.response = response;
        mapper.configure(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY, true);
    }

    public boolean isError() {
        return this.response.getError() != null;
    }

    public <T> T decomposeResponse(Class<T> clazz) {
        try {
            Object t = mapper.readValue(mapper.writeValueAsBytes((Object)this.response.getResult()), new TypeReference<T>(){});
            if (String.class.equals(clazz) && !String.class.isInstance(t)) {
                t = t.toString();
            }
            return (T)t;
        }
        catch (IOException e) {
            JsonUtils.logException(log, "Response decomposition failed", e);
            return null;
        }
    }

    public <T> T[] decomposeTypedArray(Object[] array, Class<T> clazz, String subtypeKey) {
        Object[] result = (Object[])Array.newInstance(clazz, array.length);
        for (int i = 0; i < array.length; ++i) {
            if (Map.class.isAssignableFrom(clazz)) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(subtypeKey, array[i]);
                result[i] = map;
                continue;
            }
            result[i] = array;
        }
        return result;
    }

    public Map<String, Object> decomposeError() {
        try {
            Map status = (Map)mapper.readValue(mapper.writeValueAsBytes((Object)this.response.getError()), (TypeReference)new TypeReference<HashMap<String, Object>>(){});
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("status", status);
            return map;
        }
        catch (IOException e) {
            JsonUtils.logException(log, "Response decomposition failed", e);
            return new HashMap<String, Object>();
        }
    }
}

